/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import appeng.api.util.AEPartLocation;
import appeng.client.render.effects.ParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class EnergyParticleData
implements IParticleData {
    public static final EnergyParticleData FOR_BLOCK = new EnergyParticleData(false, AEPartLocation.INTERNAL);
    public final boolean forItem;
    public final AEPartLocation direction;
    public static final IParticleData.IDeserializer<EnergyParticleData> DESERIALIZER = new IParticleData.IDeserializer<EnergyParticleData>(){

        public EnergyParticleData deserialize(ParticleType<EnergyParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            boolean forItem = reader.readBoolean();
            reader.expect(' ');
            AEPartLocation direction = AEPartLocation.valueOf(reader.readString().toUpperCase(Locale.ROOT));
            return new EnergyParticleData(forItem, direction);
        }

        public EnergyParticleData read(ParticleType<EnergyParticleData> particleTypeIn, PacketBuffer buffer) {
            boolean forItem = buffer.readBoolean();
            AEPartLocation direction = AEPartLocation.values()[buffer.readByte()];
            return new EnergyParticleData(forItem, direction);
        }
    };

    public EnergyParticleData(boolean forItem, AEPartLocation direction) {
        this.forItem = forItem;
        this.direction = direction;
    }

    public ParticleType<?> func_197554_b() {
        return ParticleTypes.ENERGY;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeBoolean(this.forItem);
        buffer.writeByte((int)((byte)this.direction.ordinal()));
    }

    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %s", this.forItem ? "true" : "false", this.direction.name().toLowerCase(Locale.ROOT));
    }
}

