/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.Icon;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class IconButton
extends Button
implements ITooltip {
    private boolean halfSize = false;
    private boolean disableClickSound = false;
    private boolean disableBackground = false;

    public IconButton(Button.IPressable onPress) {
        super(0, 0, 16, 16, StringTextComponent.field_240750_d_, onPress);
    }

    public void setVisibility(boolean vis) {
        this.field_230694_p_ = vis;
        this.field_230693_o_ = vis;
    }

    public void func_230988_a_(SoundHandler soundHandler) {
        if (!this.disableClickSound) {
            super.func_230988_a_(soundHandler);
        }
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.field_230694_p_) {
            Icon icon = this.getIcon();
            Blitter blitter = icon.getBlitter();
            if (!this.field_230693_o_) {
                blitter.opacity(0.5f);
            }
            TextureManager textureManager = minecraft.func_110434_K();
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            if (this.halfSize) {
                this.field_230688_j_ = 8;
                this.field_230689_k_ = 8;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)this.field_230690_l_, (double)this.field_230691_m_, 0.0);
                matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
                if (!this.disableBackground) {
                    Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(0, 0).blit(matrixStack, this.func_230927_p_());
                }
                blitter.dest(0, 0).blit(matrixStack, this.func_230927_p_());
                matrixStack.func_227865_b_();
            } else {
                if (!this.disableBackground) {
                    Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(this.field_230690_l_, this.field_230691_m_).blit(matrixStack, this.func_230927_p_());
                }
                icon.getBlitter().dest(this.field_230690_l_, this.field_230691_m_).blit(matrixStack, this.func_230927_p_());
            }
            RenderSystem.enableDepthTest();
            if (this.func_230449_g_()) {
                this.func_230443_a_(matrixStack, mouseX, mouseY);
            }
        }
    }

    protected abstract Icon getIcon();

    @Override
    public List<ITextComponent> getTooltipMessage() {
        return Collections.singletonList(this.func_230458_i_());
    }

    @Override
    public int getTooltipAreaX() {
        return this.field_230690_l_;
    }

    @Override
    public int getTooltipAreaY() {
        return this.field_230691_m_;
    }

    @Override
    public int getTooltipAreaWidth() {
        return this.halfSize ? 8 : 16;
    }

    @Override
    public int getTooltipAreaHeight() {
        return this.halfSize ? 8 : 16;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return this.field_230694_p_;
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }

    public boolean isDisableClickSound() {
        return this.disableClickSound;
    }

    public void setDisableClickSound(boolean disableClickSound) {
        this.disableClickSound = disableClickSound;
    }

    public boolean isDisableBackground() {
        return this.disableBackground;
    }

    public void setDisableBackground(boolean disableBackground) {
        this.disableBackground = disableBackground;
    }
}

