/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.crafting.AbstractTableRenderer;
import appeng.client.gui.me.crafting.CraftConfirmTableRenderer;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.container.me.crafting.CraftConfirmContainer;
import appeng.container.me.crafting.CraftingPlanSummary;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.NumberFormat;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CraftConfirmScreen
extends AEBaseScreen<CraftConfirmContainer> {
    private final CraftConfirmTableRenderer table = new CraftConfirmTableRenderer(this, 9, 19);
    private final Button start;
    private final Button selectCPU;
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");

    public CraftConfirmScreen(CraftConfirmContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.start = this.widgets.addButton("start", GuiText.Start.text(), this::start);
        this.start.field_230693_o_ = false;
        this.selectCPU = this.widgets.addButton("selectCpu", this.getNextCpuButtonLabel(), this::selectNextCpu);
        this.selectCPU.field_230693_o_ = false;
        this.widgets.addButton("cancel", GuiText.Cancel.text(), container::goBack);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.selectCPU.func_238482_a_(this.getNextCpuButtonLabel());
        CraftingPlanSummary plan = ((CraftConfirmContainer)this.field_147002_h).getPlan();
        boolean planIsStartable = plan != null && !plan.isSimulation();
        this.start.field_230693_o_ = !((CraftConfirmContainer)this.field_147002_h).hasNoCPU() && planIsStartable;
        this.selectCPU.field_230693_o_ = planIsStartable;
        ITextComponent planDetails = GuiText.CalculatingWait.text();
        Object cpuDetails = StringTextComponent.field_240750_d_;
        if (plan != null) {
            String byteUsed = NumberFormat.getInstance().format(plan.getUsedBytes());
            planDetails = GuiText.BytesUsed.text(byteUsed);
            cpuDetails = plan.isSimulation() ? GuiText.Simulation.text() : (((CraftConfirmContainer)this.field_147002_h).getCpuAvailableBytes() > 0L ? GuiText.ConfirmCraftCpuStatus.text(((CraftConfirmContainer)this.field_147002_h).getCpuAvailableBytes(), ((CraftConfirmContainer)this.field_147002_h).getCpuCoProcessors()) : GuiText.ConfirmCraftNoCpu.text());
        }
        this.setTextContent("dialog_title", (ITextComponent)GuiText.CraftingPlan.text(planDetails));
        this.setTextContent("cpu_status", (ITextComponent)cpuDetails);
        int size = plan != null ? plan.getEntries().size() : 0;
        this.scrollbar.setRange(0, AbstractTableRenderer.getScrollableRows(size), 1);
    }

    private ITextComponent getNextCpuButtonLabel() {
        if (((CraftConfirmContainer)this.field_147002_h).hasNoCPU()) {
            return GuiText.NoCraftingCPUs.text();
        }
        ITextComponent cpuName = ((CraftConfirmContainer)this.field_147002_h).cpuName == null ? GuiText.Automatic.text() : ((CraftConfirmContainer)this.field_147002_h).cpuName;
        return GuiText.SelectedCraftingCPU.text(cpuName);
    }

    @Override
    public void drawFG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        CraftingPlanSummary plan = ((CraftConfirmContainer)this.field_147002_h).getPlan();
        if (plan != null) {
            this.table.render(matrixStack, mouseX, mouseY, plan.getEntries(), this.scrollbar.getCurrentScroll());
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (!(this.checkHotbarKeys(InputMappings.func_197954_a((int)keyCode, (int)scanCode)) || keyCode != 257 && keyCode != 335)) {
            this.start();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
    }

    private void selectNextCpu() {
        boolean backwards = this.isHandlingRightClick();
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("Terminal.Cpu", backwards ? "Prev" : "Next"));
    }

    private void start() {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("Terminal.Start", "Start"));
    }
}

