/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.widgets.TabButton;
import appeng.container.implementations.ChestContainer;
import appeng.container.me.items.CraftingTermContainer;
import appeng.container.me.items.ItemTerminalContainer;
import appeng.container.me.items.PatternTermContainer;
import appeng.container.me.items.WirelessTermContainer;
import appeng.core.Api;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.helpers.IPriorityHost;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.CraftingTerminalPart;
import appeng.parts.reporting.PatternTerminalPart;
import appeng.parts.reporting.TerminalPart;
import appeng.tile.storage.ChestTileEntity;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public final class AESubScreen {
    private final ContainerType<?> previousContainerType;
    private final ItemStack previousContainerIcon;

    public AESubScreen(Object containerHost) {
        IDefinitions definitions = Api.instance().definitions();
        IParts parts = definitions.parts();
        if (containerHost instanceof ChestTileEntity) {
            IPriorityHost priorityHost = (IPriorityHost)containerHost;
            this.previousContainerIcon = priorityHost.getItemStackRepresentation();
            this.previousContainerType = ChestContainer.TYPE;
        } else if (containerHost instanceof IPriorityHost) {
            IPriorityHost priorityHost = (IPriorityHost)containerHost;
            this.previousContainerIcon = priorityHost.getItemStackRepresentation();
            this.previousContainerType = priorityHost.getContainerType();
        } else if (containerHost instanceof WirelessTerminalGuiObject) {
            this.previousContainerIcon = definitions.items().wirelessTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.previousContainerType = WirelessTermContainer.TYPE;
        } else if (containerHost instanceof TerminalPart) {
            this.previousContainerIcon = parts.terminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.previousContainerType = ItemTerminalContainer.TYPE;
        } else if (containerHost instanceof CraftingTerminalPart) {
            this.previousContainerIcon = parts.craftingTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.previousContainerType = CraftingTermContainer.TYPE;
        } else if (containerHost instanceof PatternTerminalPart) {
            this.previousContainerIcon = parts.patternTerminal().maybeStack(1).orElse(ItemStack.field_190927_a);
            this.previousContainerType = PatternTermContainer.TYPE;
        } else {
            this.previousContainerIcon = null;
            this.previousContainerType = null;
        }
    }

    public TabButton addBackButton(String id, WidgetContainer widgets) {
        return this.addBackButton(id, widgets, null);
    }

    public TabButton addBackButton(String id, WidgetContainer widgets, @Nullable ITextComponent label) {
        if (this.previousContainerType != null && !this.previousContainerIcon.func_190926_b()) {
            if (label == null) {
                label = this.previousContainerIcon.func_200301_q();
            }
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            TabButton button = new TabButton(this.previousContainerIcon, label, itemRenderer, btn -> this.goBack());
            widgets.add(id, (Widget)button);
            return button;
        }
        return null;
    }

    public void goBack() {
        NetworkHandler.instance().sendToServer(new SwitchGuisPacket(this.previousContainerType));
    }
}

