/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseTileBlock;
import appeng.block.misc.LightDetectorBlock;
import appeng.block.misc.SkyCompassBlock;
import appeng.block.networking.WirelessBlock;
import appeng.me.helpers.IGridProxyable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AEBaseBlockItem
extends BlockItem {
    private final AEBaseBlock blockType;

    public AEBaseBlockItem(Block id, Item.Properties props) {
        super(id, props);
        this.blockType = (AEBaseBlock)id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> toolTip, ITooltipFlag advancedTooltips) {
        this.addCheckedInformation(itemStack, world, toolTip, advancedTooltips);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addCheckedInformation(ItemStack itemStack, World world, List<ITextComponent> toolTip, ITooltipFlag advancedTooltips) {
        this.blockType.func_190948_a(itemStack, (IBlockReader)world, toolTip, advancedTooltips);
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public String func_77667_c(ItemStack is) {
        return this.blockType.func_149739_a();
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        Direction up = null;
        Direction forward = null;
        Direction side = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        if (this.blockType instanceof AEBaseTileBlock) {
            if (this.blockType instanceof LightDetectorBlock) {
                up = side;
                forward = up == Direction.UP || up == Direction.DOWN ? Direction.SOUTH : Direction.UP;
            } else if (this.blockType instanceof WirelessBlock || this.blockType instanceof SkyCompassBlock) {
                forward = side;
                up = forward == Direction.UP || forward == Direction.DOWN ? Direction.SOUTH : Direction.UP;
            } else {
                up = Direction.UP;
                forward = context.func_195992_f().func_176734_d();
                if (player != null) {
                    if (player.field_70125_A > 65.0f) {
                        up = forward.func_176734_d();
                        forward = Direction.UP;
                    } else if (player.field_70125_A < -65.0f) {
                        up = forward.func_176734_d();
                        forward = Direction.DOWN;
                    }
                }
            }
        }
        IOrientable ori = null;
        if (this.blockType instanceof IOrientableBlock) {
            ori = ((IOrientableBlock)((Object)this.blockType)).getOrientable((IBlockReader)context.func_195991_k(), context.func_195995_a());
            up = side;
            forward = Direction.SOUTH;
            if (up.func_96559_d() == 0) {
                forward = Direction.UP;
            }
        }
        if (!this.blockType.isValidOrientation((IWorld)context.func_195991_k(), context.func_195995_a(), forward, up)) {
            return ActionResultType.FAIL;
        }
        ActionResultType result = super.func_195942_a(context);
        if (!result.func_226246_a_()) {
            return result;
        }
        if (this.blockType instanceof AEBaseTileBlock && !(this.blockType instanceof LightDetectorBlock)) {
            Object tile = ((AEBaseTileBlock)this.blockType).getTileEntity((IBlockReader)context.func_195991_k(), context.func_195995_a());
            ori = tile;
            if (tile == null) {
                return result;
            }
            if (ori.canBeRotated() && !this.blockType.hasCustomRotation()) {
                ori.setOrientation(forward, up);
            }
            if (tile instanceof IGridProxyable) {
                ((IGridProxyable)tile).getProxy().setOwner(player);
            }
        } else if (this.blockType instanceof IOrientableBlock) {
            ori.setOrientation(forward, up);
        }
        return result;
    }
}

