/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;

public final class VoxelShapeUtils {
    private static final Vector3d fromOrigin = new Vector3d(-0.5, -0.5, -0.5);

    public static void print(double x1, double y1, double z1, double x2, double y2, double z2) {
        System.out.println("makeCuboidShape(" + Math.min(x1, x2) + ", " + Math.min(y1, y2) + ", " + Math.min(z1, z2) + ", " + Math.max(x1, x2) + ", " + Math.max(y1, y2) + ", " + Math.max(z1, z2) + "),");
    }

    public static void printSimplified(String name, VoxelShape shape) {
        System.out.println("Simplified: " + name);
        shape.func_197753_c().func_197756_d().forEach(box -> VoxelShapeUtils.print(box.field_72340_a * 16.0, box.field_72338_b * 16.0, box.field_72339_c * 16.0, box.field_72336_d * 16.0, box.field_72337_e * 16.0, box.field_72334_f * 16.0));
    }

    public static AxisAlignedBB rotate(AxisAlignedBB box, Direction side) {
        switch (side) {
            case DOWN: {
                return box;
            }
            case UP: {
                return new AxisAlignedBB(box.field_72340_a, -box.field_72338_b, -box.field_72339_c, box.field_72336_d, -box.field_72337_e, -box.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(box.field_72340_a, -box.field_72339_c, box.field_72338_b, box.field_72336_d, -box.field_72334_f, box.field_72337_e);
            }
            case SOUTH: {
                return new AxisAlignedBB(-box.field_72340_a, box.field_72339_c, -box.field_72338_b, -box.field_72336_d, box.field_72334_f, -box.field_72337_e);
            }
            case WEST: {
                return new AxisAlignedBB(box.field_72338_b, -box.field_72339_c, -box.field_72340_a, box.field_72337_e, -box.field_72334_f, -box.field_72336_d);
            }
            case EAST: {
                return new AxisAlignedBB(-box.field_72338_b, box.field_72339_c, box.field_72340_a, -box.field_72337_e, box.field_72334_f, box.field_72336_d);
            }
        }
        return box;
    }

    public static AxisAlignedBB rotate(AxisAlignedBB box, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return box;
            }
            case CLOCKWISE_90: {
                return new AxisAlignedBB(-box.field_72339_c, box.field_72338_b, box.field_72340_a, -box.field_72334_f, box.field_72337_e, box.field_72336_d);
            }
            case CLOCKWISE_180: {
                return new AxisAlignedBB(-box.field_72340_a, box.field_72338_b, -box.field_72339_c, -box.field_72336_d, box.field_72337_e, -box.field_72334_f);
            }
            case COUNTERCLOCKWISE_90: {
                return new AxisAlignedBB(box.field_72339_c, box.field_72338_b, -box.field_72340_a, box.field_72334_f, box.field_72337_e, -box.field_72336_d);
            }
        }
        return box;
    }

    public static AxisAlignedBB rotateHorizontal(AxisAlignedBB box, Direction side) {
        switch (side) {
            case NORTH: {
                return VoxelShapeUtils.rotate(box, Rotation.NONE);
            }
            case SOUTH: {
                return VoxelShapeUtils.rotate(box, Rotation.CLOCKWISE_180);
            }
            case WEST: {
                return VoxelShapeUtils.rotate(box, Rotation.COUNTERCLOCKWISE_90);
            }
            case EAST: {
                return VoxelShapeUtils.rotate(box, Rotation.CLOCKWISE_90);
            }
        }
        return box;
    }

    public static VoxelShape rotate(VoxelShape shape, Direction side) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotate(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotate(box, rotation));
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction side) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotateHorizontal(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, UnaryOperator<AxisAlignedBB> rotateFunction) {
        ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
        List sourceBoundingBoxes = shape.func_197756_d();
        for (AxisAlignedBB sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(VoxelShapes.func_197881_a((AxisAlignedBB)((AxisAlignedBB)rotateFunction.apply(sourceBoundingBox.func_72317_d(VoxelShapeUtils.fromOrigin.field_72450_a, VoxelShapeUtils.fromOrigin.field_72448_b, VoxelShapeUtils.fromOrigin.field_72449_c))).func_72317_d(-VoxelShapeUtils.fromOrigin.field_72450_a, -VoxelShapeUtils.fromOrigin.field_72449_c, -VoxelShapeUtils.fromOrigin.field_72449_c)));
        }
        return VoxelShapeUtils.combine(rotatedPieces);
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        return VoxelShapeUtils.batchCombine(VoxelShapes.func_197880_a(), IBooleanFunction.field_223244_o_, true, shapes);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes) {
        return VoxelShapeUtils.combine(shapes, true);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes, boolean simplify) {
        return VoxelShapeUtils.batchCombine(VoxelShapes.func_197880_a(), IBooleanFunction.field_223244_o_, simplify, shapes);
    }

    public static VoxelShape exclude(VoxelShape ... shapes) {
        return VoxelShapeUtils.batchCombine(VoxelShapes.func_197868_b(), IBooleanFunction.field_223234_e_, true, shapes);
    }

    public static VoxelShape batchCombine(VoxelShape initial, IBooleanFunction function, boolean simplify, Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = VoxelShapes.func_197882_b((VoxelShape)combinedShape, (VoxelShape)shape, (IBooleanFunction)function);
        }
        return simplify ? combinedShape.func_197753_c() : combinedShape;
    }

    public static VoxelShape batchCombine(VoxelShape initial, IBooleanFunction function, boolean simplify, VoxelShape ... shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = VoxelShapes.func_197882_b((VoxelShape)combinedShape, (VoxelShape)shape, (IBooleanFunction)function);
        }
        return simplify ? combinedShape.func_197753_c() : combinedShape;
    }
}

