/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.util;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ViewUtil {
    private static final float headSize = 0.15f;

    public static boolean isInFrontOfEntity(LivingEntity entity, Entity target) {
        Vector3d vecTargetsPos = target.func_213303_ch();
        Vector3d vecLook = entity.func_70040_Z();
        Vector3d vecFinal = vecTargetsPos.func_72444_a(new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_())).func_72432_b();
        vecFinal = new Vector3d(vecFinal.field_72450_a, 0.0, vecFinal.field_72449_c);
        return vecFinal.func_72430_b(vecLook) < 0.0;
    }

    public static boolean canEntitySee(LivingEntity viewer, LivingEntity beingViewed) {
        double dx = beingViewed.func_226277_ct_() - viewer.func_226277_ct_();
        double dz = beingViewed.func_226277_ct_() - viewer.func_226281_cx_();
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        while (viewer.field_70177_z > 360.0f) {
            viewer.field_70177_z -= 360.0f;
        }
        while (viewer.field_70177_z < -360.0f) {
            viewer.field_70177_z += 360.0f;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - viewer.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < 60.0f && yaw > -60.0f && viewer.func_70685_l((Entity)beingViewed);
    }

    public static boolean isInSightPos(LivingEntity viewer, BlockPos pos) {
        double dx = (double)pos.func_177958_n() - viewer.func_226277_ct_();
        double dz = (double)pos.func_177958_n() - viewer.func_226281_cx_();
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        while (viewer.field_70177_z > 360.0f) {
            viewer.field_70177_z -= 360.0f;
        }
        while (viewer.field_70177_z < -360.0f) {
            viewer.field_70177_z += 360.0f;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - viewer.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < 60.0f && yaw > -60.0f;
    }

    public static boolean isInSight(LivingEntity livingBase, LivingEntity angel) {
        if (ViewUtil.viewBlocked(livingBase, angel)) {
            return false;
        }
        if (livingBase instanceof PlayerEntity) {
            return ViewUtil.isInFrontOfEntity(livingBase, (Entity)angel);
        }
        return ViewUtil.isInFrontOfEntity(livingBase, (Entity)angel);
    }

    public static boolean viewBlocked(LivingEntity viewer, LivingEntity angel) {
        AxisAlignedBB viewerBoundBox = viewer.func_174813_aQ();
        AxisAlignedBB angelBoundingBox = angel.func_174813_aQ();
        Vector3d[] viewerPoints = new Vector3d[]{new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72338_b, viewerBoundBox.field_72339_c), new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72338_b, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72337_e, viewerBoundBox.field_72339_c), new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72337_e, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72337_e, viewerBoundBox.field_72339_c), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72337_e, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72338_b, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72338_b, viewerBoundBox.field_72339_c)};
        if (viewer instanceof PlayerEntity) {
            Vector3d pos2 = new Vector3d(viewer.func_226277_ct_(), viewer.func_226278_cu_() + (double)1.62f, viewer.func_226281_cx_());
            viewerPoints[0] = pos2.func_72441_c((double)-0.15f, (double)-0.15f, (double)-0.15f);
            viewerPoints[1] = pos2.func_72441_c((double)-0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[2] = pos2.func_72441_c((double)-0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[3] = pos2.func_72441_c((double)-0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[4] = pos2.func_72441_c((double)0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[5] = pos2.func_72441_c((double)0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[6] = pos2.func_72441_c((double)0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[7] = pos2.func_72441_c((double)0.15f, (double)-0.15f, (double)-0.15f);
        }
        Vector3d[] angelPoints = new Vector3d[]{new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72338_b, angelBoundingBox.field_72339_c), new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72338_b, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72337_e, angelBoundingBox.field_72339_c), new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72337_e, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72337_e, angelBoundingBox.field_72339_c), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72337_e, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72338_b, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72338_b, angelBoundingBox.field_72339_c)};
        for (int i = 0; i < viewerPoints.length; ++i) {
            if (viewer.field_70170_p.func_217299_a(new RayTraceContext(viewerPoints[i], angelPoints[i], RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)viewer)).func_216346_c() == RayTraceResult.Type.MISS) {
                return false;
            }
            if (ViewUtil.rayTraceBlocks(viewer, viewer.field_70170_p, viewerPoints[i], angelPoints[i], pos -> {
                BlockState state = viewer.field_70170_p.func_180495_p(pos);
                return !ViewUtil.canSeeThrough(state, viewer.field_70170_p, pos);
            }) != null) continue;
            return false;
        }
        if (angel.field_70173_aa % 1200 == 0 && angel.func_70032_d((Entity)viewer) < 15.0f) {
            viewer.func_195064_c(new EffectInstance(Effects.field_76440_q, 15));
        }
        return true;
    }

    public static boolean viewBlocked(LivingEntity viewer, BlockState blockState, BlockPos blockPos) {
        AxisAlignedBB viewerBoundBox = viewer.func_174813_aQ();
        AxisAlignedBB angelBoundingBox = blockState.func_196954_c((IBlockReader)viewer.field_70170_p, blockPos).func_197752_a();
        Vector3d[] viewerPoints = new Vector3d[]{new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72338_b, viewerBoundBox.field_72339_c), new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72338_b, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72337_e, viewerBoundBox.field_72339_c), new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72337_e, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72337_e, viewerBoundBox.field_72339_c), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72337_e, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72338_b, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72338_b, viewerBoundBox.field_72339_c)};
        if (viewer instanceof PlayerEntity) {
            Vector3d pos2 = new Vector3d(viewer.func_226277_ct_(), viewer.func_226278_cu_() + (double)1.62f, viewer.func_226281_cx_());
            viewerPoints[0] = pos2.func_72441_c((double)-0.15f, (double)-0.15f, (double)-0.15f);
            viewerPoints[1] = pos2.func_72441_c((double)-0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[2] = pos2.func_72441_c((double)-0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[3] = pos2.func_72441_c((double)-0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[4] = pos2.func_72441_c((double)0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[5] = pos2.func_72441_c((double)0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[6] = pos2.func_72441_c((double)0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[7] = pos2.func_72441_c((double)0.15f, (double)-0.15f, (double)-0.15f);
        }
        Vector3d[] angelPoints = new Vector3d[]{new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72338_b, angelBoundingBox.field_72339_c), new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72338_b, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72337_e, angelBoundingBox.field_72339_c), new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72337_e, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72337_e, angelBoundingBox.field_72339_c), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72337_e, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72338_b, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72338_b, angelBoundingBox.field_72339_c)};
        for (int i = 0; i < viewerPoints.length; ++i) {
            if (viewer.field_70170_p.func_217299_a(new RayTraceContext(viewerPoints[i], angelPoints[i], RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)viewer)).func_216346_c() == RayTraceResult.Type.MISS) {
                return false;
            }
            if (ViewUtil.rayTraceBlocks(viewer, viewer.field_70170_p, viewerPoints[i], angelPoints[i], pos -> {
                BlockState state = viewer.field_70170_p.func_180495_p(pos);
                return !ViewUtil.canSeeThrough(state, viewer.field_70170_p, pos);
            }) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static RayTraceResult rayTraceBlocks(LivingEntity livingEntity, World world, Vector3d vec31, Vector3d vec32, Predicate<BlockPos> stopOn) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c) || Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
            BlockRayTraceResult raytraceresult;
            int j1;
            int i1;
            int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
            int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
            int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
            int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
            BlockPos blockpos = new BlockPos(l, i1 = MathHelper.func_76128_c((double)vec31.field_72448_b), j1 = MathHelper.func_76128_c((double)vec31.field_72449_c));
            if (stopOn.test(blockpos) && (raytraceresult = world.func_217299_a(new RayTraceContext(vec31, vec32, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)livingEntity))) != null) {
                return raytraceresult;
            }
            int k1 = 200;
            while (k1-- >= 0) {
                BlockRayTraceResult raytraceresult1;
                Direction enumfacing;
                if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                    return null;
                }
                if (l == i && i1 == j && j1 == k) {
                    return null;
                }
                boolean flag2 = true;
                boolean flag = true;
                boolean flag1 = true;
                double d0 = 999.0;
                double d1 = 999.0;
                double d2 = 999.0;
                if (i > l) {
                    d0 = (double)l + 1.0;
                } else if (i < l) {
                    d0 = (double)l + 0.0;
                } else {
                    flag2 = false;
                }
                if (j > i1) {
                    d1 = (double)i1 + 1.0;
                } else if (j < i1) {
                    d1 = (double)i1 + 0.0;
                } else {
                    flag = false;
                }
                if (k > j1) {
                    d2 = (double)j1 + 1.0;
                } else if (k < j1) {
                    d2 = (double)j1 + 0.0;
                } else {
                    flag1 = false;
                }
                double d3 = 999.0;
                double d4 = 999.0;
                double d5 = 999.0;
                double d6 = vec32.field_72450_a - vec31.field_72450_a;
                double d7 = vec32.field_72448_b - vec31.field_72448_b;
                double d8 = vec32.field_72449_c - vec31.field_72449_c;
                if (flag2) {
                    d3 = (d0 - vec31.field_72450_a) / d6;
                }
                if (flag) {
                    d4 = (d1 - vec31.field_72448_b) / d7;
                }
                if (flag1) {
                    d5 = (d2 - vec31.field_72449_c) / d8;
                }
                if (d3 == -0.0) {
                    d3 = -1.0E-4;
                }
                if (d4 == -0.0) {
                    d4 = -1.0E-4;
                }
                if (d5 == -0.0) {
                    d5 = -1.0E-4;
                }
                if (d3 < d4 && d3 < d5) {
                    enumfacing = i > l ? Direction.WEST : Direction.EAST;
                    vec31 = new Vector3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                } else if (d4 < d5) {
                    enumfacing = j > i1 ? Direction.DOWN : Direction.UP;
                    vec31 = new Vector3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                } else {
                    enumfacing = k > j1 ? Direction.NORTH : Direction.SOUTH;
                    vec31 = new Vector3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                }
                if (!stopOn.test(blockpos = new BlockPos(l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == Direction.EAST ? 1 : 0), i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == Direction.UP ? 1 : 0), j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == Direction.SOUTH ? 1 : 0))) || (raytraceresult1 = world.func_217299_a(new RayTraceContext(vec31, vec32, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)livingEntity))) == null) continue;
                return raytraceresult1;
            }
        }
        return null;
    }

    public static boolean canSeeThrough(BlockState blockState, World world, BlockPos pos) {
        if (!blockState.func_200132_m() || !blockState.func_200015_d((IBlockReader)world, pos)) {
            return true;
        }
        Block block = blockState.func_177230_c();
        if (block instanceof DoorBlock) {
            return blockState.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER;
        }
        return blockState.func_196951_e((IBlockReader)world, pos) == VoxelShapes.func_197880_a();
    }
}

