/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.UUID;
import me.craig.software.regen.Regeneration;
import me.craig.software.regen.util.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public class RegenUtil {
    public static ITag.INamedTag<Block> BANNED_BLOCKS = RegenUtil.makeBlock("weeping_angels", "angel_proof");
    public static ITag.INamedTag<Block> ARS = RegenUtil.makeBlock("tardis", "ars");
    public static ITag.INamedTag<Item> TIMELORD_CURRENCY = RegenUtil.makeItem("regen", "timelord_currency");
    public static ITag.INamedTag<Block> FORGE_ZINC = RegenUtil.makeBlock("forge", "ore/zinc");
    public static ITag.INamedTag<Item> FORGE_ZINC_ITEM = RegenUtil.makeItem("forge", "ore/zinc");
    public static Random RAND = new Random();
    public static String[] USERNAMES = new String[0];

    public static Vector3d vecFromPos(Vector3i location) {
        return new Vector3d((double)location.func_177958_n() + 0.5, (double)location.func_177956_o() + 0.5, (double)location.func_177952_p() + 0.5);
    }

    public static void versionCheck(PlayerEntity playerEntity) {
        VersionChecker.CheckResult version = VersionChecker.getResult((IModInfo)((IModInfo)ModList.get().getModFileById("regen").getMods().get(0)));
        if (version.status == VersionChecker.Status.OUTDATED) {
            TranslationTextComponent click = new TranslationTextComponent("Download");
            click.func_230530_a_(Style.field_240709_b_.setUnderlined(Boolean.valueOf(true)).func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/regeneration/files")));
            TranslationTextComponent translationTextComponent = new TranslationTextComponent(TextFormatting.BOLD + "[" + TextFormatting.RESET + TextFormatting.YELLOW + "Regeneration" + TextFormatting.RESET + TextFormatting.BOLD + "]");
            translationTextComponent.func_230529_a_((ITextComponent)new TranslationTextComponent(" New Update Found: (" + version.target + ") ").func_230529_a_((ITextComponent)click));
            PlayerUtil.sendMessage((LivingEntity)playerEntity, (IFormattableTextComponent)translationTextComponent, false);
        }
    }

    public static ITag.INamedTag<Block> makeBlock(String domain, String path) {
        return BlockTags.createOptional((ResourceLocation)new ResourceLocation(domain, path));
    }

    public static ITag.INamedTag<Item> makeItem(String domain, String path) {
        return ItemTags.createOptional((ResourceLocation)new ResourceLocation(domain, path));
    }

    public static double round(float value, int scale) {
        return (double)Math.round((double)value * Math.pow(10.0, scale)) / Math.pow(10.0, scale);
    }

    public static void setupNames() {
        if (USERNAMES.length == 0) {
            try {
                ResourceLocation resourceLocation = new ResourceLocation("regen", "names.json");
                InputStream stream = ServerLifecycleHooks.getCurrentServer().getDataPackRegistries().func_240970_h_().func_199002_a(resourceLocation).func_199027_b();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                reader.close();
                stream.close();
                USERNAMES = (String[])Regeneration.GSON.fromJson(sb.toString(), String[].class);
            }
            catch (IOException e) {
                Regeneration.LOG.catching((Throwable)e);
            }
        }
    }

    public static float randFloat(float min, float max) {
        return RAND.nextFloat() * (max - min) + min;
    }

    public static boolean doesHaveInternet() {
        try {
            Socket socket = new Socket("www.google.com", 80);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] fileToBytes(File file) {
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static String encodeFileToBase64Binary(File file) throws IOException {
        byte[] encoded = Base64.encodeBase64((byte[])FileUtils.readFileToByteArray((File)file));
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    public static String colorToHex(Color color) {
        StringBuilder hex = new StringBuilder(Integer.toHexString(color.getRGB() & 0xFFFFFF));
        while (hex.length() < 6) {
            hex.insert(0, "0");
        }
        return "#" + hex;
    }

    public static String randomCode() {
        String code = String.valueOf(UUID.randomUUID());
        return code.replaceAll("-", "").replaceAll("_", "");
    }

    public static interface IEnum<E extends Enum<E>> {
        public int ordinal();

        default public E next() {
            Enum[] ies = this.getAllValues();
            return (E)(this.ordinal() != ies.length - 1 ? ies[this.ordinal() + 1] : null);
        }

        default public E previous() {
            return (E)(this.ordinal() != 0 ? this.getAllValues()[this.ordinal() - 1] : null);
        }

        default public E[] getAllValues() {
            IEnum[] ies = (IEnum[])this.getClass().getEnumConstants();
            return (Enum[])ies;
        }
    }
}

