/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.util;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import me.craig.software.regen.common.traits.AbstractTrait;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.server.ServerWorld;

public class RTextHelper {
    public static TextComponent createTextComponentWithTip(String text, String tooltipText) {
        StringTextComponent textComponent = new StringTextComponent("[" + text + "]");
        textComponent.func_240700_a_(style -> style.func_240721_b_(TextFormatting.GREEN).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(tooltipText))).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, tooltipText)));
        return textComponent;
    }

    public static TextComponent getTraitTextObject(AbstractTrait trait) {
        if (trait != null) {
            return RTextHelper.createTextComponentWithTip(RTextHelper.formatTraitName(trait), trait.getRegistryName().toString());
        }
        return RTextHelper.createTextComponentWithTip("Null Trait", "Null");
    }

    public static TextComponent getPlayerTextObject(ServerWorld world, UUID id) {
        GameProfile profileByUUID = world.func_73046_m().func_152358_ax().func_152652_a(id);
        String playerName = profileByUUID != null ? profileByUUID.getName() : "OFFLINE Player";
        return RTextHelper.createTextComponentWithTip(playerName, id.toString());
    }

    public static TextComponent getEntityTextObject(ServerWorld world, UUID id) {
        Entity entity = world.func_217461_a(id);
        String entityName = entity != null ? entity.func_200200_C_().getString() : "Null Entity";
        return RTextHelper.createTextComponentWithTip(entityName, id.toString());
    }

    public static String formatTraitName(AbstractTrait trait) {
        String original = trait.getRegistryName().func_110623_a().trim().replace("\t", "").replace("_", " ");
        String output = Arrays.stream(original.split("\\s+")).map(t -> t.substring(0, 1).toUpperCase() + t.substring(1)).collect(Collectors.joining(" "));
        return output;
    }
}

