/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import me.craig.software.regen.Regeneration;
import net.minecraft.util.JSONUtils;

public class MineSkin {
    private static final String USER_AGENT = "Regeneration MC Mod/1.0";
    private static final String URL = "https://api.mineskin.org";
    private static final String API_ENDPOINT = "https://mc.craig.software/api/skin/random-skins";

    public static ArrayList<String> getSkinsFromPage(int page) throws IOException {
        ArrayList<String> foundSkins = new ArrayList<String>();
        String urlString = "https://api.mineskin.org/get/list/" + page;
        JsonObject json = MineSkin.getApiResponse(new URL(urlString));
        for (int skins = json.getAsJsonArray("skins").size() - 1; skins >= 0; --skins) {
            JsonElement t = json.getAsJsonArray("skins").get(skins).getAsJsonObject().get("url");
            foundSkins.add(t.getAsString());
        }
        return foundSkins;
    }

    public static boolean isUserValid(UUID uuid) throws IOException {
        JsonObject response = MineSkin.getApiResponse(new URL("https://api.mineskin.org/validate/uuid/" + uuid));
        return response.get("valid").getAsBoolean() && response.has("uuid");
    }

    public static boolean isUserValid(String name, UUID uuid) throws IOException {
        JsonObject response = MineSkin.getApiResponse(new URL("https://api.mineskin.org/validate/name/" + name));
        if (!response.has("uuid")) {
            return false;
        }
        String uuidResponse = response.get("uuid").getAsString();
        return uuidResponse.equals(uuid.toString()) && response.get("valid").getAsBoolean();
    }

    public static ArrayList<String> searchSkins(String searchTerm) throws IOException {
        JsonObject response = MineSkin.getApiResponse(new URL("https://api.mineskin.org/get/list?filter=" + searchTerm));
        ArrayList<String> foundSkins = new ArrayList<String>();
        for (int skins = response.getAsJsonArray("skins").size() - 1; skins >= 0; --skins) {
            JsonElement t = response.getAsJsonArray("skins").get(skins).getAsJsonObject().get("url");
            foundSkins.add(t.getAsString());
        }
        return foundSkins;
    }

    public static JsonObject getApiResponse(URL url) throws IOException {
        HttpsURLConnection uc = (HttpsURLConnection)url.openConnection();
        uc.connect();
        uc = (HttpsURLConnection)url.openConnection();
        uc.addRequestProperty("User-Agent", USER_AGENT);
        InputStream inputStream = uc.getInputStream();
        return JSONUtils.func_212743_a((Reader)new BufferedReader(new InputStreamReader(inputStream)));
    }

    public static JsonArray getApiResponseArray(URL url) throws IOException {
        HttpsURLConnection uc = (HttpsURLConnection)url.openConnection();
        uc.connect();
        uc = (HttpsURLConnection)url.openConnection();
        uc.addRequestProperty("User-Agent", USER_AGENT);
        InputStream inputStream = uc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        return (JsonArray)JSONUtils.func_188173_a((Gson)Regeneration.GSON, (Reader)br, JsonArray.class, (boolean)false);
    }

    public static ArrayList<JsonElement> interalApiSkins() throws IOException {
        ArrayList<JsonElement> foundSkins = new ArrayList<JsonElement>();
        JsonArray json = MineSkin.getApiResponseArray(new URL(API_ENDPOINT)).getAsJsonArray();
        for (JsonElement jsonElement : json) {
            JsonObject jsonData = jsonElement.getAsJsonObject();
            foundSkins.add((JsonElement)jsonData);
        }
        System.out.println(json);
        return foundSkins;
    }
}

