/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.TimeUnit;
import me.craig.software.regen.Regeneration;
import me.craig.software.regen.client.skin.CommonSkin;
import net.minecraft.util.JSONUtils;
import org.apache.commons.io.FileUtils;

public class DownloadSkinsThread
extends Thread {
    private boolean hasStarted;

    public static void setup() {
        DownloadSkinsThread thread = new DownloadSkinsThread();
        thread.setDaemon(true);
        thread.setName("Regen - Skins");
        thread.start();
    }

    @Override
    public void run() {
        try {
            if (DownloadSkinsThread.shouldUpdateSkins() && !this.hasStarted) {
                DownloadSkinsThread.doDownloads();
                this.hasStarted = true;
                this.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void doDownloads() throws IOException {
        CommonSkin.folderSetup();
        File tempZip = new File(CommonSkin.SKIN_DIRECTORY + "/temp");
        if (tempZip.exists()) {
            FileUtils.cleanDirectory((File)tempZip);
        }
        CommonSkin.trending();
        CommonSkin.timelord();
        CommonSkin.skinpacks();
        DownloadSkinsThread.writeTime();
    }

    public static void writeTime() throws IOException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("last_downloaded", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
        try (FileWriter writer = new FileWriter(new File(CommonSkin.SKIN_DIRECTORY, "cache_tracker.json"));){
            Regeneration.GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
            writer.flush();
        }
    }

    public static boolean shouldUpdateSkins() throws FileNotFoundException {
        File cacheFile = new File(CommonSkin.SKIN_DIRECTORY, "cache_tracker.json");
        if (!cacheFile.exists()) {
            Regeneration.LOG.info("Looks like no skins have been downloaded! Commencing first time set up!");
            return true;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(cacheFile)));
        JsonObject json = JSONUtils.func_212743_a((Reader)br);
        long timeSinceDownloaded = json.getAsJsonPrimitive("last_downloaded").getAsLong();
        long minutesSince = TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - timeSinceDownloaded);
        boolean shouldDownload = minutesSince > 1440L;
        Regeneration.LOG.info("It has been {} minutes since last skin update! {}", (Object)minutesSince, (Object)(shouldDownload ? "A Skin update will commence!" : "A Skin update will not commence just now!"));
        return shouldDownload;
    }
}

