/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import me.craig.software.regen.client.RKeybinds;
import me.craig.software.regen.client.rendering.JarParticle;
import me.craig.software.regen.client.rendering.JarTileRender;
import me.craig.software.regen.client.rendering.entity.RenderLaser;
import me.craig.software.regen.client.rendering.entity.TimelordRenderer;
import me.craig.software.regen.client.rendering.entity.WatcherRenderer;
import me.craig.software.regen.client.rendering.layers.HandLayer;
import me.craig.software.regen.client.rendering.layers.RenderRegenLayer;
import me.craig.software.regen.client.rendering.model.armor.GuardModel;
import me.craig.software.regen.client.rendering.model.armor.RobesModel;
import me.craig.software.regen.client.rendering.transitions.BlazeTransitionRenderer;
import me.craig.software.regen.client.rendering.transitions.EnderDragonTransitionRenderer;
import me.craig.software.regen.client.rendering.transitions.FieryTransitionRenderer;
import me.craig.software.regen.client.rendering.transitions.MinecraftFlameTransitionRenderer;
import me.craig.software.regen.client.rendering.transitions.SparkleTransitionRenderer;
import me.craig.software.regen.client.rendering.transitions.TroughtonTransitionRenderer;
import me.craig.software.regen.client.rendering.transitions.WatcherTransitionRenderer;
import me.craig.software.regen.client.sound.SoundReverb;
import me.craig.software.regen.common.item.ElixirItem;
import me.craig.software.regen.common.item.FobWatchItem;
import me.craig.software.regen.common.item.HandItem;
import me.craig.software.regen.common.item.SpawnItem;
import me.craig.software.regen.common.objects.RBlocks;
import me.craig.software.regen.common.objects.REntities;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.common.objects.RParticles;
import me.craig.software.regen.common.objects.RTiles;
import me.craig.software.regen.common.regen.transitions.TransitionType;
import me.craig.software.regen.common.regen.transitions.TransitionTypeRenderers;
import me.craig.software.regen.common.regen.transitions.TransitionTypes;
import me.craig.software.regen.config.RegenConfig;
import me.craig.software.regen.util.sound.MovingSound;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabVanilla;
import micdoodle8.mods.galacticraft.api.client.tabs.RegenPrefTab;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientUtil {
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("textures/environment/sun.png");
    public static HashMap<Item, BipedModel<?>> ARMOR_MODELS = new HashMap();

    public static String getImgurLink(String base64Image) throws Exception {
        String line;
        URL url = new URL("https://who-craft.com/api/index.php");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String data = URLEncoder.encode("image", "UTF-8") + "=" + URLEncoder.encode(base64Image, "UTF-8");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.connect();
        StringBuilder stb = new StringBuilder();
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data);
        wr.flush();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            stb.append(line).append("\n");
        }
        wr.close();
        rd.close();
        JsonElement jelement = new JsonParser().parse(stb.toString());
        JsonObject jobject = jelement.getAsJsonObject();
        if (JSONUtils.func_151204_g((JsonObject)jobject, (String)"link")) {
            return JSONUtils.func_151200_h((JsonObject)jobject, (String)"link");
        }
        throw new Exception(JSONUtils.func_151200_h((JsonObject)jobject, (String)"message"));
    }

    @SubscribeEvent
    public static void registerParticles(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)RParticles.CONTAINER.get(), JarParticle.Factory::new);
    }

    public static boolean isAlex(Entity livingEntity) {
        if (livingEntity instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity abstractClientPlayerEntity = (AbstractClientPlayerEntity)livingEntity;
            if (abstractClientPlayerEntity.field_175157_a == null || abstractClientPlayerEntity.field_175157_a.field_178863_g == null) {
                return false;
            }
            if (abstractClientPlayerEntity.field_175157_a.field_178863_g.isEmpty()) {
                return false;
            }
            return Objects.equals(abstractClientPlayerEntity.field_175157_a.field_178863_g, "slim");
        }
        return false;
    }

    public static void clothingModels() {
        RobesModel robesHead = new RobesModel(EquipmentSlotType.HEAD);
        RobesModel robesChest = new RobesModel(EquipmentSlotType.CHEST);
        RobesModel robesLegs = new RobesModel(EquipmentSlotType.LEGS);
        RobesModel robesFeet = new RobesModel(EquipmentSlotType.FEET);
        ARMOR_MODELS.put((Item)RItems.F_ROBES_HEAD.get(), robesHead);
        ARMOR_MODELS.put((Item)RItems.M_ROBES_HEAD.get(), robesHead);
        ARMOR_MODELS.put((Item)RItems.F_ROBES_CHEST.get(), robesChest);
        ARMOR_MODELS.put((Item)RItems.M_ROBES_CHEST.get(), robesChest);
        ARMOR_MODELS.put((Item)RItems.F_ROBES_LEGS.get(), robesLegs);
        ARMOR_MODELS.put((Item)RItems.M_ROBES_LEGS.get(), robesLegs);
        ARMOR_MODELS.put((Item)RItems.ROBES_FEET.get(), robesFeet);
        GuardModel guardHead = new GuardModel(EquipmentSlotType.HEAD);
        GuardModel guardChest = new GuardModel(EquipmentSlotType.CHEST);
        GuardModel guardLegs = new GuardModel(EquipmentSlotType.LEGS);
        GuardModel guardFeet = new GuardModel(EquipmentSlotType.FEET);
        ARMOR_MODELS.put((Item)RItems.GUARD_HELMET.get(), guardHead);
        ARMOR_MODELS.put((Item)RItems.GUARD_CHEST.get(), guardChest);
        ARMOR_MODELS.put((Item)RItems.GUARD_LEGS.get(), guardLegs);
        ARMOR_MODELS.put((Item)RItems.GUARD_FEET.get(), guardFeet);
    }

    public static BipedModel<?> getArmorModel(ItemStack itemStack) {
        if (!ARMOR_MODELS.containsKey(itemStack.func_77973_b())) {
            throw new UnsupportedOperationException("No model registered for: " + itemStack.func_77973_b());
        }
        return ARMOR_MODELS.get(itemStack.func_77973_b());
    }

    public static void doClientStuff() {
        ClientUtil.renderLayers();
        ClientUtil.clientRenders();
        ClientUtil.itemPredicates();
        ClientUtil.setupTabs();
        ClientUtil.clothingModels();
        ClientUtil.transitionTypes();
        RKeybinds.init();
        TabRegistry.registerEventListeners(MinecraftForge.EVENT_BUS);
        RenderTypeLookup.setRenderLayer((Block)((Block)RBlocks.BIO_CONTAINER.get()), (RenderType)RenderType.func_228641_d_());
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, color) -> color > 0 ? -1 : ElixirItem.getTrait(stack).color(), new IItemProvider[]{(IItemProvider)RItems.ELIXIR.get()});
    }

    private static void transitionTypes() {
        TransitionTypeRenderers.add((TransitionType)TransitionTypes.FIERY.get(), FieryTransitionRenderer.INSTANCE);
        TransitionTypeRenderers.add((TransitionType)TransitionTypes.MINECRAFT_FLAME.get(), MinecraftFlameTransitionRenderer.INSTANCE);
        TransitionTypeRenderers.add((TransitionType)TransitionTypes.TROUGHTON.get(), TroughtonTransitionRenderer.INSTANCE);
        TransitionTypeRenderers.add((TransitionType)TransitionTypes.WATCHER.get(), WatcherTransitionRenderer.INSTANCE);
        TransitionTypeRenderers.add((TransitionType)TransitionTypes.SPARKLE.get(), SparkleTransitionRenderer.INSTANCE);
        TransitionTypeRenderers.add((TransitionType)TransitionTypes.BLAZE.get(), BlazeTransitionRenderer.INSTANCE);
        TransitionTypeRenderers.add((TransitionType)TransitionTypes.ENDER_DRAGON.get(), EnderDragonTransitionRenderer.INSTANCE);
    }

    private static void renderLayers() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        for (PlayerRenderer renderPlayer : skinMap.values()) {
            renderPlayer.func_177094_a((LayerRenderer)new HandLayer((IEntityRenderer)renderPlayer));
            renderPlayer.func_177094_a((LayerRenderer)new RenderRegenLayer((IEntityRenderer)renderPlayer));
        }
        Minecraft.func_71410_x().func_175598_ae().field_78729_o.forEach((entityType, entityRenderer) -> {
            if (entityRenderer instanceof BipedRenderer) {
                BipedRenderer bipedRenderer = (BipedRenderer)entityRenderer;
                bipedRenderer.func_177094_a((LayerRenderer)new RenderRegenLayer((IEntityRenderer)bipedRenderer));
                bipedRenderer.func_177094_a((LayerRenderer)new HandLayer((IEntityRenderer)entityRenderer));
            }
        });
    }

    private static void setupTabs() {
        MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
        if (TabRegistry.getTabList().size() < 2) {
            TabRegistry.registerTab(new InventoryTabVanilla());
        }
        TabRegistry.registerTab(new RegenPrefTab());
    }

    private static void itemPredicates() {
        ItemModelsProperties.func_239418_a_((Item)((Item)RItems.FOB.get()), (ResourceLocation)new ResourceLocation("regen", "model"), (stack, p_call_2_, p_call_3_) -> {
            boolean isGold = FobWatchItem.getEngrave(stack);
            boolean isOpen = FobWatchItem.isOpen(stack);
            if (isOpen && isGold) {
                return 0.2f;
            }
            if (!isOpen && !isGold) {
                return 0.3f;
            }
            if (isOpen) {
                return 0.4f;
            }
            return 0.1f;
        });
        ItemModelsProperties.func_239418_a_((Item)((Item)RItems.RIFLE.get()), (ResourceLocation)new ResourceLocation("regen", "aim"), (stack, p_call_2_, livingEntity) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.func_184605_cv() > 0 ? 1.0f : 0.0f;
        });
        ItemModelsProperties.func_239418_a_((Item)((Item)RItems.PISTOL.get()), (ResourceLocation)new ResourceLocation("regen", "aim"), (stack, p_call_2_, livingEntity) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.func_184605_cv() > 0 ? 1.0f : 0.0f;
        });
        ItemModelsProperties.func_239418_a_((Item)((Item)RItems.HAND.get()), (ResourceLocation)new ResourceLocation("regen", "skin_type"), (stack, p_call_2_, livingEntity) -> HandItem.isAlex(stack) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)((Item)RItems.SPAWN_ITEM.get()), (ResourceLocation)new ResourceLocation("regen", "timelord"), (itemStack, clientWorld, livingEntity) -> {
            if (itemStack == null || itemStack.func_190926_b()) {
                return 0.0f;
            }
            SpawnItem.Timelord type = SpawnItem.getType(itemStack);
            return type.ordinal();
        });
        SoundReverb.addReloader();
    }

    private static void clientRenders() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)RTiles.HAND_JAR.get()), JarTileRender::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)REntities.TIMELORD.get()), TimelordRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)REntities.LASER.get()), RenderLaser::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)REntities.WATCHER.get()), WatcherRenderer::new);
    }

    public static void playPositionedSoundRecord(SoundEvent sound, float pitch, float volume) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void playSound(Object entity, ResourceLocation soundName, SoundCategory category, boolean repeat, Supplier<Boolean> stopCondition, float volume) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSound(entity, new SoundEvent(soundName), category, repeat, stopCondition, volume));
    }

    public static void createToast(TranslationTextComponent title, TranslationTextComponent subtitle) {
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new SystemToast(SystemToast.Type.TUTORIAL_HINT, (ITextComponent)title, (ITextComponent)subtitle));
    }

    public static void setPlayerPerspective(String pointOfView) {
        if (((Boolean)RegenConfig.CLIENT.changePerspective.get()).booleanValue()) {
            Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.valueOf((String)pointOfView));
        }
    }

    public static void renderSky(MatrixStack matrixStackIn) {
        if (Minecraft.func_71410_x().field_71441_e == null || matrixStackIn == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e.func_234923_W_() != null && Minecraft.func_71410_x().field_71441_e.func_234923_W_().func_240901_a_().toString().equalsIgnoreCase("regen:gallifrey")) {
            float scale = 30.0f;
            BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(5.0f, 5.0f, 5.0f);
            matrixStackIn.func_227861_a_(22.0, 22.0, -22.0);
            Matrix4f matrix4f1 = matrixStackIn.func_227866_c_().func_227870_a_();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(SUN_TEXTURES);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_227888_a_(matrix4f1, -scale, 100.0f, -scale).func_225583_a_(0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, scale, 100.0f, -scale).func_225583_a_(1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, scale, 100.0f, scale).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_227888_a_(matrix4f1, -scale, 100.0f, scale).func_225583_a_(0.0f, 1.0f).func_181675_d();
            matrixStackIn.func_227865_b_();
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        }
    }
}

