/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.network.messages;

import java.util.UUID;
import java.util.function.Supplier;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.util.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.network.NetworkEvent;

public class SFXMessage {
    private final ResourceLocation sound;
    private final UUID playerUUID;

    public SFXMessage(ResourceLocation sound, UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.sound = sound;
    }

    public SFXMessage(PacketBuffer buffer) {
        this.sound = buffer.func_192575_l();
        this.playerUUID = buffer.func_179253_g();
    }

    public static void handle(SFXMessage message, Supplier<NetworkEvent.Context> ctx) {
        Minecraft.func_71410_x().func_213165_a(() -> {
            PlayerEntity player = Minecraft.func_71410_x().field_71441_e.func_217371_b(message.playerUUID);
            if (player != null) {
                RegenCap.get((LivingEntity)player).ifPresent(data -> ClientUtil.playSound(player, message.sound, SoundCategory.PLAYERS, true, () -> !data.regenState().equals((Object)RegenStates.REGENERATING), 1.0f));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_192572_a(this.sound);
        buffer.func_179252_a(this.playerUUID);
    }
}

