/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.craig.software.regen.Regeneration;
import me.craig.software.regen.common.advancement.TriggerManager;
import me.craig.software.regen.common.commands.RegenCommand;
import me.craig.software.regen.common.item.HandItem;
import me.craig.software.regen.common.objects.REntities;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.common.traits.AbstractTrait;
import me.craig.software.regen.common.traits.RegenTraitRegistry;
import me.craig.software.regen.common.world.gen.RStructures;
import me.craig.software.regen.config.RegenConfig;
import me.craig.software.regen.util.PlayerUtil;
import me.craig.software.regen.util.RConstants;
import me.craig.software.regen.util.RegenSources;
import me.craig.software.regen.util.RegenUtil;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    private static Method GETCODEC_METHOD;

    @SubscribeEvent
    public static void onAttachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
        if (CommonEvents.canBeGiven((Entity)event.getObject())) {
            event.addCapability(RConstants.CAP_REGEN_ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                final RegenCap regen;
                final LazyOptional<IRegen> regenInstance;
                {
                    this.regen = new RegenCap((LivingEntity)event.getObject());
                    this.regenInstance = LazyOptional.of(() -> this.regen);
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return cap == RegenCap.CAPABILITY ? this.regenInstance : LazyOptional.empty();
                }

                public CompoundNBT serializeNBT() {
                    return this.regen.serializeNBT();
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    this.regen.deserializeNBT(nbt);
                }
            });
        }
    }

    public static boolean canBeGiven(Entity entity) {
        boolean ignoresConfig;
        boolean isLiving = entity instanceof LivingEntity && entity.func_200600_R() != EntityType.field_200789_c;
        boolean bl = ignoresConfig = entity.func_200600_R() == REntities.TIMELORD.get() || entity.func_200600_R() == EntityType.field_200729_aH;
        if (isLiving && ignoresConfig) {
            return true;
        }
        if (isLiving) {
            return (Boolean)RegenConfig.COMMON.mobsHaveRegens.get();
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void noFire(LivingAttackEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        RegenCap.get(event.getEntityLiving()).ifPresent(iRegen -> {
            if (iRegen.regenState() == RegenStates.REGENERATING && ((Boolean)RegenConfig.COMMON.regenFireImmune.get()).booleanValue() && event.getSource().func_76347_k() || iRegen.regenState() == RegenStates.REGENERATING && event.getSource().func_94541_c()) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void noFall(LivingFallEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        RegenCap.get(event.getEntityLiving()).ifPresent(iRegen -> {
            if (iRegen.trait().getRegistryName().toString().equals(((AbstractTrait)RegenTraitRegistry.LEAP.get()).getRegistryName().toString())) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity == null) {
            return;
        }
        RegenCap.get(livingEntity).ifPresent(iRegen -> {
            Entity trueSource = event.getSource().func_76346_g();
            if (event.getSource().func_76347_k() && iRegen.trait().getRegistryName().toString().equals(((AbstractTrait)RegenTraitRegistry.FIRE.get()).getRegistryName().toString())) {
                event.setCanceled(true);
                event.setAmount(0.0f);
                return;
            }
            if (trueSource instanceof PlayerEntity && event.getEntityLiving() != null) {
                PlayerEntity player = (PlayerEntity)trueSource;
                RegenCap.get((LivingEntity)player).ifPresent(data -> data.stateManager().onPunchEntity(event));
            }
            if (event.getSource() == RegenSources.REGEN_DMG_KILLED) {
                return;
            }
            iRegen.setDeathMessage(event.getSource().func_151519_b(livingEntity).getString());
            if (iRegen.trait().getRegistryName().toString().equals(((AbstractTrait)RegenTraitRegistry.LEAP.get()).getRegistryName().toString()) && event.getSource() == DamageSource.field_76379_h) {
                event.setCanceled(true);
                return;
            }
            if (iRegen.regenState() == RegenStates.POST && event.getSource() != DamageSource.field_76380_i && event.getSource() != RegenSources.REGEN_DMG_HAND) {
                event.setAmount(1.5f);
                PlayerUtil.sendMessage(livingEntity, (IFormattableTextComponent)new TranslationTextComponent("regen.messages.reduced_dmg"), true);
            }
            if (iRegen.regenState() == RegenStates.REGENERATING && ((Boolean)RegenConfig.COMMON.regenFireImmune.get()).booleanValue() && event.getSource().func_76347_k() || iRegen.regenState() == RegenStates.REGENERATING && event.getSource().func_94541_c()) {
                event.setCanceled(true);
                return;
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void adMortemInimicusButForGrace(LivingDamageEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        RegenCap.get(event.getEntityLiving()).ifPresent(cap -> {
            if (cap.regenState().isGraceful() && event.getEntityLiving().func_110143_aJ() - event.getAmount() < 0.0f) {
                boolean notDead = cap.stateManager().onKilled(event.getSource());
                event.setCanceled(notDead);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void adMortemInimicus(LivingDeathEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        RegenCap.get(event.getEntityLiving()).ifPresent(cap -> {
            if (event.getSource() == RegenSources.REGEN_DMG_CRITICAL || event.getSource() == RegenSources.REGEN_DMG_KILLED) {
                cap.setTrait((AbstractTrait)RegenTraitRegistry.BORING.get());
                if (((Boolean)RegenConfig.COMMON.loseRegensOnDeath.get()).booleanValue()) {
                    cap.extractRegens(cap.regens());
                }
                if (event.getEntityLiving() instanceof ServerPlayerEntity) {
                    cap.syncToClients((ServerPlayerEntity)event.getEntityLiving());
                }
                return;
            }
            if (cap.stateManager() == null) {
                return;
            }
            boolean notDead = cap.stateManager().onKilled(event.getSource());
            event.setCanceled(notDead);
        });
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        RegenCap.get(livingEntity).ifPresent(data -> event.setCanceled(data.regenState() == RegenStates.REGENERATING));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Capability.IStorage storage = RegenCap.CAPABILITY.getStorage();
        event.getOriginal().revive();
        RegenCap.get((LivingEntity)event.getOriginal()).ifPresent(old -> RegenCap.get((LivingEntity)event.getPlayer()).ifPresent(data -> {
            CompoundNBT nbt = (CompoundNBT)storage.writeNBT(RegenCap.CAPABILITY, old, null);
            storage.readNBT(RegenCap.CAPABILITY, data, null, (INBT)nbt);
        }));
    }

    @SubscribeEvent
    public static void onTrackPlayer(PlayerEvent.StartTracking startTracking) {
        RegenCap.get((LivingEntity)startTracking.getPlayer()).ifPresent(iRegen -> iRegen.syncToClients(null));
    }

    @SubscribeEvent
    public static void onPunchBlock(PlayerInteractEvent.LeftClickBlock e) {
        if (e.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        RegenCap.get((LivingEntity)e.getPlayer()).ifPresent(data -> data.stateManager().onPunchBlock(e));
    }

    @SubscribeEvent
    public static void onLive(LivingEvent.LivingUpdateEvent livingUpdateEvent) {
        RegenCap.get(livingUpdateEvent.getEntityLiving()).ifPresent(IRegen::tick);
        if (livingUpdateEvent.getEntityLiving() instanceof ServerPlayerEntity && CommonEvents.shouldGiveCouncilAdvancement((ServerPlayerEntity)livingUpdateEvent.getEntity())) {
            TriggerManager.COUNCIL.trigger((ServerPlayerEntity)livingUpdateEvent.getEntityLiving());
        }
    }

    public static boolean shouldGiveCouncilAdvancement(ServerPlayerEntity serverPlayerEntity) {
        EquipmentSlotType[] equipmentSlotTypes;
        for (EquipmentSlotType equipmentSlotType : equipmentSlotTypes = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET}) {
            if (serverPlayerEntity.func_184582_a(equipmentSlotType).func_77973_b().getRegistryName().func_110623_a().contains("robes")) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        RegenCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onCut(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().func_77973_b() instanceof ToolItem || event.getItemStack().func_77973_b() instanceof SwordItem) {
            PlayerEntity player = event.getPlayer();
            RegenCap.get((LivingEntity)player).ifPresent(data -> {
                if (data.regenState() == RegenStates.POST && player.func_225608_bj_() & data.handState() == IRegen.Hand.NO_GONE) {
                    HandItem.createHand((LivingEntity)player);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void space(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ChunkGenerator chunkGenerator = serverWorld.func_72863_F().func_201711_g();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"codec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)chunkGenerator, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                Regeneration.LOG.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            if (serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
                tempMap.put((Structure)RStructures.Structures.HUTS.get(), (StructureSeparationSettings)DimensionStructuresSettings.field_236191_b_.get((Object)RStructures.Structures.HUTS.get()));
                serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
            }
        }
    }

    @SubscribeEvent
    public static void onLoad(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)event.getEntity();
            RegenUtil.versionCheck(playerEntity);
        }
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent biomeLoadingEvent) {
        Biome.Category biomeCategory = biomeLoadingEvent.getCategory();
        if (biomeCategory != Biome.Category.ICY && biomeCategory != Biome.Category.MUSHROOM && biomeCategory != Biome.Category.JUNGLE && biomeCategory != Biome.Category.OCEAN && biomeCategory != Biome.Category.RIVER && biomeCategory != Biome.Category.DESERT) {
            biomeLoadingEvent.getGeneration().getStructures().add(() -> RStructures.ConfiguredStructures.CONFIGURED_HUTS);
            Regeneration.LOG.info("Added Huts to: " + biomeLoadingEvent.getName());
        }
        if (biomeCategory != Biome.Category.NETHER && biomeCategory != Biome.Category.THEEND) {
            biomeLoadingEvent.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, RStructures.GAl_ORE);
        }
    }
}

