/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.handlers;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.concurrent.atomic.AtomicReference;
import me.craig.software.regen.Regeneration;
import me.craig.software.regen.client.RKeybinds;
import me.craig.software.regen.client.rendering.JarTileRender;
import me.craig.software.regen.client.rendering.entity.TimelordRenderer;
import me.craig.software.regen.client.skin.SkinHandler;
import me.craig.software.regen.common.item.GunItem;
import me.craig.software.regen.common.objects.RSounds;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.common.regen.transitions.TransitionType;
import me.craig.software.regen.common.regen.transitions.TransitionTypeRenderers;
import me.craig.software.regen.common.regen.transitions.TransitionTypes;
import me.craig.software.regen.config.RegenConfig;
import me.craig.software.regen.util.PlayerUtil;
import me.craig.software.regen.util.RenderHelp;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    public static ResourceLocation OLD = AbstractGui.field_230665_h_;
    public static ResourceLocation NEW = new ResourceLocation("regen", "textures/gui/crosshair.png");
    public static ResourceLocation HEARTS = new ResourceLocation("regen", "textures/gui/hearts.png");
    public static boolean shouldReset = false;
    private static ISound iSound = null;

    @SubscribeEvent
    public static void on(ClientChatEvent event) {
    }

    public static void updateShaders(Entity entity) {
        if (!((Boolean)RegenConfig.CLIENT.shaders.get()).booleanValue()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        GameRenderer renderer = Minecraft.func_71410_x().field_71460_t;
        AtomicReference shader = new AtomicReference();
        RegenCap.get((LivingEntity)entity).ifPresent(iRegen -> {
            boolean regeneratingTroughton;
            boolean bl = regeneratingTroughton = iRegen.regenState() == RegenStates.REGENERATING && iRegen.transitionType() == TransitionTypes.TROUGHTON.get();
            if ((iRegen.regenState() == RegenStates.ALIVE || iRegen.regenState() == RegenStates.REGENERATING && !regeneratingTroughton || PlayerUtil.isPlayerAboveZeroGrid((LivingEntity)entity)) && shouldReset) {
                renderer.func_181022_b();
                return;
            }
            if (iRegen.regenState() == RegenStates.GRACE_CRIT && !ClientEvents.checkShaderLoaded(renderer, "blur")) {
                shader.set("blur");
                shouldReset = true;
            }
            if (iRegen.regenState() == RegenStates.POST && !PlayerUtil.isPlayerAboveZeroGrid((LivingEntity)entity) && !ClientEvents.checkShaderLoaded(renderer, "deconverge")) {
                shader.set("deconverge");
                shouldReset = true;
            }
        });
        if (shader.get() != null) {
            renderer.func_175069_a(new ResourceLocation("shaders/post/" + shader + ".json"));
        }
    }

    private static boolean checkShaderLoaded(GameRenderer renderer, String shader) {
        if (renderer.func_147706_e() == null) {
            return false;
        }
        return renderer.func_147706_e().func_148022_b().toLowerCase().contains(shader);
    }

    @SubscribeEvent
    public static void onName(RenderNameplateEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        RegenCap.get((LivingEntity)player).ifPresent(iRegen -> {
            if (iRegen.regenState() == RegenStates.POST && !PlayerUtil.isPlayerAboveZeroGrid((LivingEntity)player) || iRegen.regenState() == RegenStates.GRACE_CRIT) {
                event.setContent((ITextComponent)new StringTextComponent(TextFormatting.OBFUSCATED + event.getContent().getString()));
            }
        });
    }

    @SubscribeEvent
    public static void onRenderPlayerPre(RenderPlayerEvent.Pre playerEvent) {
        PlayerEntity player = playerEvent.getPlayer();
        SkinHandler.tick(player);
        RegenCap.get((LivingEntity)player).ifPresent(iRegen -> {
            TransitionType type = iRegen.transitionType();
            TransitionTypeRenderers.get(type).onPlayerRenderPre(playerEvent);
        });
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post playerEvent) {
        PlayerEntity player = playerEvent.getPlayer();
        RegenCap.get((LivingEntity)player).ifPresent(iRegen -> {
            TransitionType type = iRegen.transitionType();
            TransitionTypeRenderers.get(type).onPlayerRenderPost(playerEvent);
        });
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        RegenCap.get((LivingEntity)Minecraft.func_71410_x().field_71439_g).ifPresent(iRegen -> TransitionTypeRenderers.get(iRegen.transitionType()).firstPersonHand(event));
    }

    @SubscribeEvent
    public static void onTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        RKeybinds.tickKeybinds();
        if (Minecraft.func_71410_x().field_71439_g != null) {
            ClientPlayerEntity ep = Minecraft.func_71410_x().field_71439_g;
            SoundHandler sound = Minecraft.func_71410_x().func_147118_V();
            RegenCap.get((LivingEntity)ep).ifPresent(iRegen -> {
                if (iRegen.regenState() == RegenStates.POST && PlayerUtil.isPlayerAboveZeroGrid((LivingEntity)ep)) {
                    if (iSound == null) {
                        iSound = SimpleSound.func_239532_b_((SoundEvent)((SoundEvent)RSounds.GRACE_HUM.get()), (float)1.0f, (float)1.0f);
                    }
                    if (!sound.func_215294_c(iSound)) {
                        sound.func_147682_a(iSound);
                    }
                } else if (sound.func_215294_c(iSound)) {
                    sound.func_147683_b(iSound);
                }
            });
        }
        ClientEvents.destroyTextures();
    }

    private static void destroyTextures() {
        if (Minecraft.func_71410_x().field_71441_e == null && SkinHandler.PLAYER_SKINS.size() > 0) {
            SkinHandler.PLAYER_SKINS.forEach((uuid, texture) -> Minecraft.func_71410_x().func_110434_K().func_147645_c(texture));
            SkinHandler.PLAYER_SKINS.clear();
            TimelordRenderer.TIMELORDS.forEach((uuid, texture) -> Minecraft.func_71410_x().func_110434_K().func_147645_c(texture));
            TimelordRenderer.TIMELORDS.clear();
            JarTileRender.TEXTURES.forEach((uuid, texture) -> Minecraft.func_71410_x().func_110434_K().func_147645_c(texture));
            JarTileRender.TEXTURES.clear();
            Regeneration.LOG.warn("Cleared Regeneration texture cache");
        }
    }

    @SubscribeEvent
    public static void onColorFog(EntityViewRenderEvent.FogColors e) {
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        if (!(Minecraft.func_71410_x().func_175606_aa() instanceof LivingEntity)) {
            return;
        }
        RegenCap.get((LivingEntity)renderView).ifPresent(data -> {
            if (data.regenState() == RegenStates.GRACE_CRIT) {
                e.setRed(0.5f);
                e.setBlue(0.5f);
                e.setGreen(0.5f);
            }
            if (data.transitionType() == TransitionTypes.TROUGHTON.get() && data.regenState() == RegenStates.REGENERATING) {
                e.setRed(0.0f);
                e.setGreen(0.0f);
                e.setBlue(0.0f);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ClientEvents.updateShaders(Minecraft.func_71410_x().func_175606_aa());
        RegenCap.get((LivingEntity)player).ifPresent(cap -> {
            String warning = null;
            ClientEvents.handleGunCrosshair(event, player, cap);
            if (event.getType() != RenderGameOverlayEvent.ElementType.HELMET) {
                return;
            }
            if (cap.regenState() == RegenStates.REGENERATING && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                event.setCanceled(true);
            }
            ITextComponent forceKeybind = RKeybinds.FORCE_REGEN.getKey().func_237520_d_();
            switch (cap.regenState()) {
                case GRACE: {
                    RenderHelp.renderVig(cap.getPrimaryColors(), 0.3f);
                    warning = new TranslationTextComponent("regen.messages.warning.grace", new Object[]{forceKeybind.getString()}).getString();
                    break;
                }
                case GRACE_CRIT: {
                    RenderHelp.renderVig(new Vector3d(1.0, 0.0, 0.0), 0.5f);
                    warning = new TranslationTextComponent("regen.messages.warning.grace_critical", new Object[]{forceKeybind.getString()}).getString();
                    break;
                }
                case REGENERATING: {
                    RenderHelp.renderVig(cap.getSecondaryColors(), 0.5f);
                    break;
                }
                case POST: {
                    if (player.field_70737_aN <= 0 && player.func_70660_b(Effects.field_76431_k) == null) break;
                    RenderHelp.renderVig(cap.getSecondaryColors(), 0.5f);
                }
            }
            if (cap.glowing()) {
                RenderHelp.renderVig(((TransitionType)TransitionTypes.FIERY.get()).getDefaultPrimaryColor(), 0.5f);
            }
            IRenderTypeBuffer.Impl renderImpl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            if (warning != null) {
                Minecraft.func_71410_x().field_71466_p.func_228079_a_(warning, (float)(Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(warning) / 2), 4.0f, TextFormatting.WHITE.func_211163_e().intValue(), false, TransformationMatrix.func_227983_a_().func_227988_c_(), (IRenderTypeBuffer)renderImpl, false, 0, 0xF000F0);
            }
            renderImpl.func_228461_a_();
        });
    }

    private static void handleGunCrosshair(RenderGameOverlayEvent.Pre event, ClientPlayerEntity player, IRegen cap) {
        boolean gunSight = player.func_184614_ca().func_77973_b() instanceof GunItem && player.func_184605_cv() > 0;
        boolean healthCheck = event.getType().name().toLowerCase().contains("health");
        if (gunSight && healthCheck) {
            event.setCanceled(true);
        }
        AbstractGui.field_230665_h_ = gunSight ? HEARTS : OLD;
    }

    @SubscribeEvent
    public static void onSetupFogDensity(EntityViewRenderEvent.FogDensity event) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        if (viewer instanceof LivingEntity) {
            RegenCap.get((LivingEntity)viewer).ifPresent(data -> {
                if (data.regenState() == RegenStates.GRACE_CRIT) {
                    GlStateManager.func_227750_p_((int)GlStateManager.FogMode.EXP.field_187351_d);
                    event.setCanceled(true);
                    event.setDensity(0.1f);
                }
                if (data.transitionType() == TransitionTypes.TROUGHTON.get() && data.updateTicks() > 0) {
                    event.setCanceled(true);
                    event.setDensity(0.3f);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent e) {
        if (e.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)e.getEntityLiving();
            SkinHandler.PLAYER_SKINS.remove(player.func_110124_au());
            if (player.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                SkinHandler.sendResetMessage();
            }
        }
    }

    @SubscribeEvent
    public static void keyInput(InputUpdateEvent e) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        RegenCap.get((LivingEntity)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
            if (data.regenState() == RegenStates.REGENERATING) {
                MovementInput moveType = e.getMovementInput();
                ClientEvents.blockMovement(moveType);
                ClientEvents.upwardsMovement(player, data);
            }
        });
    }

    private static void upwardsMovement(ClientPlayerEntity player, IRegen data) {
        if (data.transitionType() == TransitionTypes.ENDER_DRAGON.get() && ((Boolean)RegenConfig.COMMON.allowUpwardsMotion.get()).booleanValue() && player.func_233580_cy_().func_177956_o() <= 100) {
            BlockPos upwards = player.func_233580_cy_().func_177981_b(2);
            BlockPos pos = upwards.func_177973_b((Vector3i)player.func_233580_cy_());
            Vector3d vec = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72432_b();
            player.func_213317_d(player.func_213322_ci().func_178787_e(vec.func_186678_a(0.1)));
        }
    }

    private static void blockMovement(MovementInput moveType) {
        moveType.field_187258_f = false;
        moveType.field_187257_e = false;
        moveType.field_187256_d = false;
        moveType.field_78901_c = false;
        moveType.field_192832_b = 0.0f;
        moveType.field_228350_h_ = false;
        moveType.field_78902_a = 0.0f;
    }
}

