/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import me.craig.software.regen.common.advancement.BaseTrigger;
import me.craig.software.regen.common.advancement.TriggerManager;
import me.craig.software.regen.common.objects.RBlocks;
import me.craig.software.regen.common.objects.RItems;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AdvancementGen
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<Advancement> advancements = new ArrayList<Advancement>();
    private final DataGenerator generator;

    public AdvancementGen(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public void func_200398_a(DirectoryCache p_200398_1_) throws IOException {
        Path path = this.generator.func_200391_b();
        TriggerManager.init();
        Advancement watchIsMe = this.createAdvancement("watch_is_me", new ItemStack((IItemProvider)RItems.FOB.get()), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)RItems.FOB.get()}), null, FrameType.GOAL);
        Advancement firstRegeneration = this.createAdvancement("first_regen", new ItemStack((IItemProvider)Blocks.field_196710_eS), new BaseTrigger.Instance(TriggerManager.FIRST_REGENERATION.func_192163_a()), watchIsMe, FrameType.CHALLENGE);
        Advancement changeRefuse = this.createAdvancement("change_refusal", new ItemStack((IItemProvider)RBlocks.BIO_CONTAINER.get()), new BaseTrigger.Instance(TriggerManager.CHANGE_REFUSAL.func_192163_a()), firstRegeneration);
        this.createAdvancement("critical_period", new ItemStack((IItemProvider)Items.field_151113_aN), new BaseTrigger.Instance(TriggerManager.CRITICAL.func_192163_a()), changeRefuse);
        Advancement cutHand = this.createAdvancement("hand_cut", new ItemStack((IItemProvider)RItems.HAND.get()), new BaseTrigger.Instance(TriggerManager.HAND_CUT.func_192163_a()), changeRefuse);
        this.createAdvancement("zero_room", new ItemStack((IItemProvider)RBlocks.ZERO_ROUNDEL.get()), new BaseTrigger.Instance(TriggerManager.ZERO_ROOM.func_192163_a()), cutHand);
        Advancement trade = this.createAdvancement("timelord_trade", new ItemStack((IItemProvider)RItems.SPAWN_ITEM.get()), new BaseTrigger.Instance(TriggerManager.TIMELORD_TRADE.func_192163_a()), watchIsMe);
        Advancement guard = this.createAdvancement("guard", new ItemStack((IItemProvider)RItems.GUARD_HELMET.get()), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{() -> (Item)RItems.GUARD_HELMET.get(), () -> (Item)RItems.GUARD_CHEST.get(), () -> (Item)RItems.GUARD_FEET.get(), () -> (Item)RItems.GUARD_LEGS.get()}), trade);
        this.createAdvancement("gallifreyan_weapon", new ItemStack((IItemProvider)RItems.PISTOL.get()), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{() -> (Item)RItems.PISTOL.get(), () -> (Item)RItems.RIFLE.get()}), guard);
        Advancement council = this.createAdvancement("council", new ItemStack((IItemProvider)RItems.M_ROBES_HEAD.get()), new BaseTrigger.Instance(TriggerManager.COUNCIL.func_192163_a()), trade);
        for (Advancement adv : advancements) {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)p_200398_1_, (JsonElement)adv.func_192075_a().func_200273_b(), (Path)AdvancementGen.getPath(path, adv));
        }
    }

    public String func_200397_b() {
        return "Advancements";
    }

    public Advancement create(String name, String title, ItemStack display, Advancement parent, FrameType frameType, ICriterionInstance ... inst) {
        Advancement.Builder adv = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)display.func_77973_b(), (ITextComponent)new TranslationTextComponent("advancements.regen.title." + title), (ITextComponent)new TranslationTextComponent("advancements.regen.desc." + title), new ResourceLocation("regen:textures/block/zero_roundel_half.png"), frameType, true, true, false);
        int i = 0;
        for (ICriterionInstance in : inst) {
            adv = adv.func_200275_a(i + "", in);
            ++i;
        }
        if (parent != null) {
            adv.func_203905_a(parent);
        }
        return adv.func_192056_a(new ResourceLocation("regen", name));
    }

    public Advancement createAdvancement(String name, ItemStack display, ICriterionInstance inst, Advancement parent) {
        return this.createAdvancement(name, display, inst, parent, FrameType.TASK);
    }

    public Advancement createAdvancement(String name, ItemStack display, ICriterionInstance inst, Advancement parent, FrameType frameType) {
        Advancement advance = this.create(name, name, display, parent, frameType, inst);
        advancements.add(advance);
        return advance;
    }
}

