/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.compat;

import java.util.List;
import me.craig.software.regen.Regeneration;
import me.craig.software.regen.common.entities.TimelordEntity;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.acting.Acting;
import me.craig.software.regen.common.regen.acting.ActingForwarder;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.util.PlayerUtil;
import me.craig.software.regen.util.RegenUtil;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.CrashType;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.world.dimensions.TDimensions;

public class TardisMod
implements Acting {
    public static void tardis() {
        MinecraftForge.EVENT_BUS.register((Object)new TardisMod());
        Regeneration.LOG.info("Tardis Mod Detected! Enabling Compatibility Features!");
        ActingForwarder.register(TardisMod.class, Dist.DEDICATED_SERVER);
    }

    public boolean isTardis(World world) {
        return WorldHelper.areDimensionTypesSame((World)world, (RegistryKey)TDimensions.DimensionTypes.TARDIS_TYPE);
    }

    @SubscribeEvent
    public void onLive(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof TimelordEntity) {
            TimelordEntity timelordEntity = (TimelordEntity)event.getEntity();
            if (timelordEntity.getTimelordType() == TimelordEntity.TimelordType.COUNCIL) {
                timelordEntity.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)timelordEntity, DalekEntity.class, 15.0f, 0.5, 0.5));
            }
            if (timelordEntity.getTimelordType() == TimelordEntity.TimelordType.GUARD) {
                timelordEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)timelordEntity, DalekEntity.class, false));
            }
        }
        if (event.getEntity() instanceof DalekEntity) {
            DalekEntity dalekEntity = (DalekEntity)event.getEntity();
            dalekEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)dalekEntity, TimelordEntity.class, false));
        }
    }

    @Override
    public void onRegenTick(IRegen cap) {
        ConsoleTile console;
        World world = cap.getLiving().field_70170_p;
        if (cap.regenState() == RegenStates.REGENERATING && this.isTardis(cap.getLiving().field_70170_p) && !PlayerUtil.isPlayerAboveZeroGrid(cap.getLiving()) && (console = (ConsoleTile)world.func_175625_s(TardisHelper.TARDIS_POS)).func_145831_w().func_82737_E() % 5L == 0L) {
            if (console.isInFlight() && world.field_73012_v.nextInt(100) < 5) {
                console.crash(new CrashType(70, 7.0f, true));
                return;
            }
            List subsystems = console.getSubSystems();
            if (!subsystems.isEmpty()) {
                Subsystem randomSubsystem = (Subsystem)subsystems.get(world.field_73012_v.nextInt(subsystems.size()));
                if (world.field_73012_v.nextBoolean()) {
                    for (int i = 0; i < 18; ++i) {
                        double angle = Math.toRadians(i * 20);
                        double x = Math.sin(angle);
                        double z = Math.cos(angle);
                        BlockPos pos = new BlockPos(0, 128, 0);
                        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)TSounds.ELECTRIC_SPARK.get(), SoundCategory.BLOCKS, 0.05f, 1.0f, false);
                        world.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)pos.func_177958_n() + 0.5 + x, (double)pos.func_177956_o() + world.field_73012_v.nextDouble(), (double)pos.func_177952_p() + 0.5 + z, 0.0, 0.0, 0.0);
                    }
                    if (randomSubsystem.getHealth() > 0.0f) {
                        randomSubsystem.damage(null, world.field_73012_v.nextInt(5));
                    }
                }
            }
        }
    }

    @Override
    public void onEnterGrace(IRegen cap) {
    }

    @Override
    public void onHandsStartGlowing(IRegen cap) {
    }

    @Override
    public void onGoCritical(IRegen cap) {
        World world = cap.getLiving().field_70170_p;
        if (this.isTardis(cap.getLiving().field_70170_p) && !PlayerUtil.isPlayerAboveZeroGrid(cap.getLiving())) {
            ConsoleTile console = (ConsoleTile)world.func_175625_s(TardisHelper.TARDIS_POS);
            console.getInteriorManager().setAlarmOn(true);
        }
    }

    @Override
    public void onRegenTrigger(IRegen cap) {
        World world = cap.getLiving().field_70170_p;
        if (this.isTardis(cap.getLiving().field_70170_p) && !PlayerUtil.isPlayerAboveZeroGrid(cap.getLiving())) {
            ConsoleTile console = (ConsoleTile)world.func_175625_s(TardisHelper.TARDIS_POS);
            console.getInteriorManager().setAlarmOn(true);
        }
    }

    @Override
    public void onRegenFinish(IRegen cap) {
        World world = cap.getLiving().field_70170_p;
        if (this.isTardis(cap.getLiving().field_70170_p)) {
            ConsoleTile console = (ConsoleTile)world.func_175625_s(TardisHelper.TARDIS_POS);
            if (cap.getLiving() instanceof PlayerEntity) {
                PlayerEntity playerEntity = (PlayerEntity)cap.getLiving();
                console.getEmotionHandler().setLoyalty(playerEntity.func_110124_au(), console.getEmotionHandler().getLoyalty(playerEntity.func_110124_au()) - RegenUtil.RAND.nextInt(25));
                console.getInteriorManager().setAlarmOn(false);
                console.getUnlockManager().addConsoleRoom((ConsoleRoom)ConsoleRoom.getRegistry().get(new ResourceLocation("regen", "mccoy")));
            }
        }
    }

    @Override
    public void onPerformingPost(IRegen cap) {
    }
}

