/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.world.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.craig.software.regen.Regeneration;
import me.craig.software.regen.common.objects.RBlocks;
import me.craig.software.regen.common.world.gen.GallifreyanHuts;
import me.craig.software.regen.common.world.gen.HutPieces;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RStructures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"regen");
    public static final RegistryObject<Feature<OreFeatureConfig>> ZINC = FEATURES.register("zinc", () -> new OreFeature(OreFeatureConfig.field_236566_a_));
    public static ConfiguredFeature<?, ?> GAl_ORE = null;

    public static void registerConfiguredFeatures() {
        GAl_ORE = (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)((Feature)ZINC.get()).func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)RBlocks.ZINC_ORE.get()).func_176223_P(), 9)).func_242733_d(32)).func_242728_a()).func_242729_a(2);
        RStructures.registerConfiguredFeature("zinc", GAl_ORE);
    }

    private static <T extends Feature<?>> void registerConfiguredFeature(String registryName, ConfiguredFeature<?, ?> configuredFeature) {
        Registry registry = WorldGenRegistries.field_243653_e;
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("regen", registryName), configuredFeature);
    }

    public static void setupStructures() {
        RStructures.setupStructure((Structure)Structures.HUTS.get(), new StructureSeparationSettings(400, 140, 1234567890), true);
    }

    private static <T extends Structure<?>> void registerConfiguredStructure(String registryName, Supplier<T> structure, StructureFeature<?, ?> configuredStructure) {
        Registry registry = WorldGenRegistries.field_243654_f;
        Registry.func_218322_a((Registry)registry, (ResourceLocation)new ResourceLocation("regen", registryName), configuredStructure);
        FlatGenerationSettings.field_202247_j.put((Structure)structure.get(), configuredStructure);
    }

    private static <T extends Structure<?>> RegistryObject<T> setupStructure(String name, Supplier<T> structure) {
        return Structures.STRUCTURES.register(name, structure);
    }

    public static <F extends Structure<?>> void setupStructure(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        if (ModList.get().isLoaded("terraforged")) {
            RStructures.addHackyStructureModCompat(structure, structureSeparationSettings);
        }
    }

    public static <F extends Structure<?>> void addHackyStructureModCompat(F structure, StructureSeparationSettings structureSeparationSettings) {
        WorldGenRegistries.field_243658_j.forEach(settings -> {
            Map structureMap = settings.func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                settings.func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
            Regeneration.LOG.info("Added compatibility with other world generation mods for structure {}: Adding StructureSeperationSettings early into WorldGenRegistries!", (Object)structure.getRegistryName().toString());
            Regeneration.LOG.info("Warning: This may break compatibility with vanilla datapacks!");
        });
    }

    public static IStructurePieceType registerStructurePiece(IStructurePieceType type, String key) {
        return (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)new ResourceLocation("regen", key), (Object)type);
    }

    static /* synthetic */ RegistryObject access$000(String x0, Supplier x1) {
        return RStructures.setupStructure(x0, x1);
    }

    public static class ConfiguredStructures {
        public static StructureFeature<?, ?> CONFIGURED_HUTS = ((Structure)Structures.HUTS.get()).func_236391_a_((IFeatureConfig)new ProbabilityConfig(1.0f));

        public static void registerConfiguredStructures() {
            RStructures.registerConfiguredStructure("configured_huts", Structures.HUTS, ConfiguredStructures.CONFIGURED_HUTS);
        }
    }

    public static class Structures {
        public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"regen");
        public static final RegistryObject<Structure<ProbabilityConfig>> HUTS = RStructures.access$000("hut", () -> new GallifreyanHuts((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_));
        public static IStructurePieceType HUT_PIECE = RStructures.registerStructurePiece(HutPieces.Piece::new, "hut_piece");
    }
}

