/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.world.gen;

import java.util.List;
import java.util.Random;
import me.craig.software.regen.common.entities.TimelordEntity;
import me.craig.software.regen.common.objects.REntities;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.world.gen.RStructures;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class HutPieces {
    private static final ResourceLocation HUT = new ResourceLocation("regen", "gallifrey_shack");
    private static final ResourceLocation HUT_1 = new ResourceLocation("regen", "gallifrey_barn_d");
    private static final ResourceLocation HUT_2 = new ResourceLocation("regen", "gallifrey_barn_m");
    private static final ResourceLocation[] ALL_STRUCTURES = new ResourceLocation[]{HUT, HUT_1, HUT_2};

    public static void start(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> pieceList, Random random) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).func_190942_a(rotation);
        BlockPos blockpos = rotationOffSet.func_177982_a(x, pos.func_177956_o(), z);
        pieceList.add((StructurePiece)new Piece(templateManager, ALL_STRUCTURES[random.nextInt(ALL_STRUCTURES.length)], blockpos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation resourceLocation;
        private final Rotation rotation;

        public Piece(TemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotationIn) {
            super(RStructures.Structures.HUT_PIECE, 0);
            this.resourceLocation = resourceLocationIn;
            BlockPos blockpos = BlockPos.field_177992_a;
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.rotation = rotationIn;
            this.setupPiece(templateManagerIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT tagCompound) {
            super(RStructures.Structures.HUT_PIECE, tagCompound);
            this.resourceLocation = new ResourceLocation(tagCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.setupPiece(templateManagerIn);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("timelord".equals(function)) {
                TimelordEntity timelordEntity = (TimelordEntity)((EntityType)REntities.TIMELORD.get()).func_200721_a((World)worldIn.func_201672_e());
                RegenCap.get((LivingEntity)timelordEntity).ifPresent(iRegen -> {
                    timelordEntity.initSkin((IRegen)iRegen);
                    timelordEntity.genName();
                    iRegen.setRegens(rand.nextInt(12));
                    timelordEntity.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 90.0f, 90.0f);
                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    iRegen.syncToClients(null);
                    worldIn.func_217376_c((Entity)timelordEntity);
                });
            }
            if ("chest_stone".equals(function)) {
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177984_a(), (ResourceLocation)LootTables.field_186426_h);
                worldIn.func_180501_a(pos, Blocks.field_150348_b.func_176223_P(), 2);
            }
            if ("barrel_down".equals(function)) {
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)LootTables.field_186426_h);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
    }
}

