/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.tiles;

import java.util.Random;
import javax.annotation.Nonnull;
import me.craig.software.regen.common.item.HandItem;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.common.objects.RParticles;
import me.craig.software.regen.common.objects.RSounds;
import me.craig.software.regen.common.objects.RTiles;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class JarTile
extends TileEntity
implements ITickableTileEntity {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private boolean updateSkin = true;
    private boolean isOpen = false;
    private float openAmount = 0.0f;

    public JarTile() {
        super((TileEntityType)RTiles.HAND_JAR.get());
    }

    public static void spawnParticles(World world, BlockPos blockPos) {
        Random random = world.field_73012_v;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = blockPos.func_177972_a(direction);
            if (world.func_180495_p(blockpos).func_200015_d((IBlockReader)world, blockpos)) continue;
            Direction.Axis direction$axis = direction.func_176740_k();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.func_82601_c() : (double)random.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.func_96559_d() : (double)random.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.func_82599_e() : (double)random.nextFloat();
            world.func_195594_a((IParticleData)RParticles.CONTAINER.get(), (double)blockPos.func_177958_n() + d1, (double)blockPos.func_177956_o() + d2, (double)blockPos.func_177952_p() + d3, 0.0, 0.0, 0.0);
        }
    }

    public float getLindos() {
        return HandItem.getEnergy(this.getHand());
    }

    public void setLindos(float lindos) {
        lindos = MathHelper.func_76131_a((float)lindos, (float)0.0f, (float)100.0f);
        HandItem.setEnergy(lindos, this.getHand());
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean open) {
        this.isOpen = open;
    }

    public float getOpenAmount() {
        return this.openAmount;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_73660_a() {
        this.isOpen = this.getHand().func_190926_b();
        this.openAmount = this.isOpen ? (this.openAmount += 0.1f) : (this.openAmount -= 0.1f);
        if (this.openAmount > 1.0f) {
            this.openAmount = 1.0f;
        }
        if (this.openAmount < 0.0f) {
            this.openAmount = 0.0f;
        }
        if (this.isValid(Action.CREATE)) {
            JarTile.spawnParticles(this.field_145850_b, this.field_174879_c);
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 77L == 0L && !this.isOpen) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)RSounds.JAR_BUBBLES.get(), SoundCategory.PLAYERS, 0.2f, 0.2f);
        }
        if (this.field_145850_b.func_82737_E() % 100L == 0L && this.updateSkin) {
            this.setUpdateSkin(false);
        }
    }

    public boolean isValid(Action action) {
        if (action == Action.ADD) {
            return this.getHand().func_77973_b() == RItems.HAND.get() && this.getLindos() < 100.0f;
        }
        if (action == Action.CREATE) {
            return this.getHand().func_77973_b() == RItems.HAND.get() && this.getLindos() >= 100.0f;
        }
        return false;
    }

    public void dropHandIfPresent(@Nullable PlayerEntity player) {
        if (!this.getHand().func_190926_b()) {
            if (player != null) {
                if (!player.func_191521_c(this.getHand())) {
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.getHand());
                }
            } else {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.getHand());
            }
            this.setHand(ItemStack.field_190927_a);
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void sendUpdates() {
        this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.func_70296_d();
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.setLindos(nbt.func_74760_g("energy"));
        if (nbt.func_74764_b("inv")) {
            this.itemHandler.deserializeNBT(nbt.func_74775_l("inv"));
        }
        this.setUpdateSkin(nbt.func_74767_n("update_skin"));
        this.setOpen(nbt.func_74767_n("is_open"));
        this.openAmount = nbt.func_74760_g("openAmount");
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74776_a("energy", this.getLindos());
        compound.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        compound.func_74757_a("update_skin", this.updateSkin);
        compound.func_74757_a("is_open", this.isOpen);
        compound.func_74776_a("openAmount", this.openAmount);
        return super.func_189515_b(compound);
    }

    public boolean isUpdateSkin() {
        return this.updateSkin;
    }

    public void setUpdateSkin(boolean updateSkin) {
        this.updateSkin = updateSkin;
    }

    public ItemStack getHand() {
        return this.itemHandler.getStackInSlot(0);
    }

    public void setHand(ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
        this.func_70296_d();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.handler.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                JarTile.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() == RItems.HAND.get();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (stack.func_77973_b() != RItems.HAND.get()) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public static enum Action {
        ADD,
        CREATE;

    }
}

