/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.regen.transitions;

import java.util.List;
import me.craig.software.regen.common.entities.WatcherEntity;
import me.craig.software.regen.common.objects.REntities;
import me.craig.software.regen.common.objects.RSounds;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.transitions.TransitionType;
import me.craig.software.regen.common.regen.transitions.TransitionTypes;
import me.craig.software.regen.network.NetworkDispatcher;
import me.craig.software.regen.network.messages.POVMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public final class WatcherTransition
extends TransitionType {
    public static void createWatcher(LivingEntity player) {
        RegenCap.get(player).ifPresent(iRegen -> {
            if (iRegen.transitionType() == TransitionTypes.WATCHER.get()) {
                Direction facing = player.func_184172_bi();
                BlockPos playerPos = player.func_233580_cy_();
                BlockPos spawnPos = playerPos.func_177967_a(facing, 4);
                WatcherEntity watcherEntity = new WatcherEntity(player.field_70170_p);
                watcherEntity.func_70624_b(player);
                watcherEntity.func_70634_a(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
                player.field_70170_p.func_217376_c((Entity)watcherEntity);
            }
        });
    }

    @Override
    public void tick(IRegen cap) {
        LivingEntity living = cap.getLiving();
        World world = living.field_70170_p;
        List watchers = world.func_217394_a((EntityType)REntities.WATCHER.get(), living.func_174813_aQ().func_186662_g(64.0), watcherEntity -> watcherEntity.func_70638_az() == living);
        if (watchers.isEmpty()) {
            WatcherTransition.createWatcher(living);
        }
    }

    @Override
    public int getAnimationLength() {
        return 340;
    }

    @Override
    public SoundEvent[] getRegeneratingSounds() {
        return new SoundEvent[]{(SoundEvent)RSounds.REGENERATION_WATCHER.get()};
    }

    @Override
    public Vector3d getDefaultPrimaryColor() {
        return Vector3d.field_186680_a;
    }

    @Override
    public Vector3d getDefaultSecondaryColor() {
        return Vector3d.field_186680_a;
    }

    @Override
    public void onFinishRegeneration(IRegen cap) {
        LivingEntity living = cap.getLiving();
        if (living instanceof ServerPlayerEntity) {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)cap.getLiving()), (Object)new POVMessage("FIRST_PERSON"));
        }
    }

    @Override
    public void onStartRegeneration(IRegen cap) {
        if (cap.getLiving() instanceof ServerPlayerEntity) {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)cap.getLiving()), (Object)new POVMessage("THIRD_PERSON_FRONT"));
        }
    }

    @Override
    public void onUpdateMidRegen(IRegen cap) {
        LivingEntity living = cap.getLiving();
    }
}

