/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.regen.acting;

import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import me.craig.software.regen.common.advancement.TriggerManager;
import me.craig.software.regen.common.block.JarBlock;
import me.craig.software.regen.common.objects.RParticles;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.acting.Acting;
import me.craig.software.regen.common.regen.transitions.WatcherTransition;
import me.craig.software.regen.common.tiles.JarTile;
import me.craig.software.regen.common.traits.AbstractTrait;
import me.craig.software.regen.common.traits.RegenTraitRegistry;
import me.craig.software.regen.config.RegenConfig;
import me.craig.software.regen.network.NetworkDispatcher;
import me.craig.software.regen.network.messages.SFXMessage;
import me.craig.software.regen.util.PlayerUtil;
import me.craig.software.regen.util.RegenSources;
import me.craig.software.regen.util.RegenUtil;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

class CommonActing
implements Acting {
    public static final Acting INSTANCE = new CommonActing();
    private final UUID SLOWNESS_ID = UUID.fromString("f9aa2c36-f3f3-4d76-a148-86d6f2c87782");
    private final UUID MAX_HEALTH_ID = UUID.fromString("5d6f0ba2-1286-46fc-b896-461c5cfd99cc");
    private final double HEART_REDUCTION = 0.5;
    private final double SPEED_REDUCTION = 0.35;
    private final AttributeModifier slownessModifier = new AttributeModifier(this.SLOWNESS_ID, "slow", -0.35, AttributeModifier.Operation.MULTIPLY_BASE);
    private final AttributeModifier heartModifier = new AttributeModifier(this.MAX_HEALTH_ID, "short-heart", -0.5, AttributeModifier.Operation.MULTIPLY_BASE);

    public static SoundEvent getRandomSound(Random random, IRegen cap) {
        SoundEvent[] soundEvents = cap.transitionType().getRegeneratingSounds();
        return soundEvents[random.nextInt(soundEvents.length)];
    }

    @Override
    public void onRegenTick(IRegen cap) {
        LivingEntity livingEntity = cap.getLiving();
        float stateProgress = (float)cap.stateManager().stateProgress();
        switch (cap.regenState()) {
            case POST: {
                if (!PlayerUtil.POTIONS.isEmpty() && livingEntity.field_70173_aa % 210 == 0 && !PlayerUtil.isPlayerAboveZeroGrid(livingEntity)) {
                    PlayerUtil.applyPotionIfAbsent(livingEntity, PlayerUtil.POTIONS.get(livingEntity.field_70170_p.field_73012_v.nextInt(PlayerUtil.POTIONS.size())), livingEntity.field_70170_p.field_73012_v.nextInt(400), 1, false, false);
                }
                if (!PlayerUtil.isPlayerAboveZeroGrid(livingEntity)) break;
                PlayerUtil.handleZeroGrid(livingEntity);
                break;
            }
            case REGENERATING: {
                if (livingEntity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity playerEntity = (ServerPlayerEntity)livingEntity;
                    TriggerManager.FIRST_REGENERATION.trigger(playerEntity);
                }
                float dm = Math.max(1.0f, (float)(livingEntity.field_70170_p.func_175659_aa().func_151525_a() + 1) / 3.0f);
                livingEntity.func_70691_i(stateProgress * 0.3f * dm);
                livingEntity.func_85034_r(0);
                AxisAlignedBB box = livingEntity.func_174813_aQ().func_186662_g(25.0);
                Iterator iterator = BlockPos.func_218281_b((BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f), (BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c)).iterator();
                while (iterator.hasNext()) {
                    JarTile jarTile;
                    ServerWorld serverWorld = (ServerWorld)livingEntity.field_70170_p;
                    BlockPos pos = (BlockPos)iterator.next();
                    BlockState blockState = serverWorld.func_180495_p(pos);
                    if (!(blockState.func_177230_c() instanceof JarBlock) || !(jarTile = (JarTile)serverWorld.func_175625_s(pos)).isValid(JarTile.Action.ADD)) continue;
                    if (livingEntity.field_70170_p.field_73012_v.nextBoolean() && serverWorld.func_82737_E() % 5L == 0L) {
                        jarTile.setLindos(jarTile.getLindos() + 0.7f);
                        BlockPos artonPos = livingEntity.func_233580_cy_();
                        Vector3d end = RegenUtil.vecFromPos((Vector3i)artonPos);
                        Vector3d start = RegenUtil.vecFromPos((Vector3i)jarTile.func_174877_v().func_177977_b());
                        Vector3d path = start.func_178788_d(end);
                        for (int i = 0; i < 20; ++i) {
                            double percent = (double)i / 10.0;
                            Vector3d spawnPoint = new Vector3d((double)artonPos.func_177958_n() + 0.5 + path.func_82615_a() * percent, (double)artonPos.func_177956_o() + 1.3 + path.func_82617_b() * percent, (double)artonPos.func_177952_p() + 0.5 + path.field_72449_c * percent);
                            serverWorld.func_195598_a((IParticleData)((BasicParticleType)RParticles.CONTAINER.get()), spawnPoint.field_72450_a, spawnPoint.field_72448_b, spawnPoint.field_72449_c, 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                    jarTile.sendUpdates();
                    return;
                }
                break;
            }
            case GRACE_CRIT: {
                float nauseaPercentage = 0.5f;
                if (stateProgress > nauseaPercentage) {
                    PlayerUtil.applyPotionIfAbsent(livingEntity, Effects.field_76431_k, (int)((float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20) * (1.0f - nauseaPercentage) * 1.5f), 0, false, false);
                }
                PlayerUtil.applyPotionIfAbsent(livingEntity, Effects.field_76437_t, (int)((float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20) * (1.0f - stateProgress)), 0, false, false);
                if (!(livingEntity.field_70170_p.field_73012_v.nextDouble() < (double)((float)((Integer)RegenConfig.COMMON.criticalDamageChance.get()).intValue() / 100.0f))) break;
                livingEntity.func_70097_a(RegenSources.REGEN_DMG_CRITICAL, livingEntity.field_70170_p.field_73012_v.nextFloat() + 0.5f);
                break;
            }
            case GRACE: {
                float weaknessPercentage = 0.5f;
                if (!(stateProgress > weaknessPercentage)) break;
                PlayerUtil.applyPotionIfAbsent(livingEntity, Effects.field_76437_t, (int)((float)((Integer)RegenConfig.COMMON.gracePhaseLength.get() * 20) * (1.0f - weaknessPercentage) + (float)((Integer)RegenConfig.COMMON.criticalPhaseLength.get() * 20)), 0, false, false);
                break;
            }
            case ALIVE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)cap.regenState()));
            }
        }
    }

    @Override
    public void onEnterGrace(IRegen cap) {
        LivingEntity player = cap.getLiving();
        PlayerUtil.explodeKnockback((Entity)player, player.field_70170_p, new BlockPos(player.func_213303_ch()), (Double)RegenConfig.COMMON.regenerativeKnockback.get() / 2.0, (Integer)RegenConfig.COMMON.regenKnockbackRange.get());
        player.func_110149_m(player.func_110138_aP() * 0.5f);
        if (!player.func_110148_a(Attributes.field_233818_a_).func_180374_a(this.heartModifier)) {
            player.func_110148_a(Attributes.field_233818_a_).func_233769_c_(this.heartModifier);
        }
        player.func_70606_j(player.func_110138_aP());
        WatcherTransition.createWatcher(player);
    }

    @Override
    public void onHandsStartGlowing(IRegen cap) {
        PlayerUtil.sendMessage(cap.getLiving(), (IFormattableTextComponent)new TranslationTextComponent("regen.messages.regen_warning"), true);
    }

    @Override
    public void onGoCritical(IRegen cap) {
        if (!cap.getLiving().func_110148_a(Attributes.field_233821_d_).func_180374_a(this.slownessModifier)) {
            cap.getLiving().func_110148_a(Attributes.field_233821_d_).func_233769_c_(this.slownessModifier);
        }
    }

    @Override
    public void onRegenFinish(IRegen cap) {
        LivingEntity player = cap.getLiving();
        player.func_195064_c(new EffectInstance(Effects.field_76428_l, ((Integer)RegenConfig.COMMON.postRegenerationDuration.get()).intValue(), (Integer)RegenConfig.COMMON.postRegenerationLevel.get() - 1, false, false));
        player.func_70606_j(player.func_110138_aP());
        player.func_110149_m((float)((Integer)RegenConfig.COMMON.absorbtionLevel.get() * 2));
        cap.setNextSkin(new byte[0]);
        player.func_110148_a(Attributes.field_233818_a_).func_111124_b(this.heartModifier);
        player.func_110148_a(Attributes.field_233821_d_).func_111124_b(this.slownessModifier);
        if (((Boolean)RegenConfig.COMMON.traitsEnabled.get()).booleanValue() && cap.getLiving().func_200600_R() == EntityType.field_200729_aH) {
            AbstractTrait old = cap.trait();
            old.remove(cap);
            AbstractTrait next = cap.getNextTrait();
            if (next.getRegistryName().toString().equals(((AbstractTrait)RegenTraitRegistry.BORING.get()).getRegistryName().toString())) {
                next = RegenTraitRegistry.getRandomTrait(cap.getLiving().func_70681_au(), !(cap.getLiving() instanceof PlayerEntity));
            }
            next.apply(cap);
            cap.setTrait(next);
            cap.setNextTrait((AbstractTrait)RegenTraitRegistry.BORING.get());
            PlayerUtil.sendMessage(player, (IFormattableTextComponent)new TranslationTextComponent("regen.messages.new_trait", new Object[]{next.translation().getString()}), true);
        } else {
            cap.trait().remove(cap);
            cap.setTrait((AbstractTrait)RegenTraitRegistry.BORING.get());
            cap.trait().apply(cap);
        }
    }

    @Override
    public void onPerformingPost(IRegen cap) {
    }

    @Override
    public void onRegenTrigger(IRegen cap) {
        LivingEntity living = cap.getLiving();
        if (cap.getLiving() instanceof PlayerEntity) {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.DIMENSION.with(() -> living.func_130014_f_().func_234923_W_()), (Object)new SFXMessage(CommonActing.getRandomSound(living.func_70681_au(), cap).getRegistryName(), living.func_110124_au()));
        } else {
            living.func_184185_a(CommonActing.getRandomSound(living.func_70681_au(), cap), 1.0f, 1.0f);
        }
        living.func_110148_a(Attributes.field_233818_a_).func_188479_b(this.MAX_HEALTH_ID);
        living.func_110148_a(Attributes.field_233821_d_).func_188479_b(this.SLOWNESS_ID);
        living.func_70606_j(Math.max(living.func_110143_aJ(), 8.0f));
        living.func_110149_m(0.0f);
        living.func_70066_B();
        living.func_184226_ay();
        living.func_195061_cb();
        living.func_184210_p();
        if (living instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)living;
            if (((Boolean)RegenConfig.COMMON.resetHunger.get()).booleanValue()) {
                playerEntity.func_71024_bL().func_75114_a(20);
            }
        }
        if (((Boolean)RegenConfig.COMMON.resetOxygen.get()).booleanValue()) {
            living.func_70050_g(300);
        }
        cap.extractRegens(1);
    }
}

