/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.regen.acting;

import java.io.File;
import me.craig.software.regen.Regeneration;
import me.craig.software.regen.client.skin.CommonSkin;
import me.craig.software.regen.client.skin.SkinHandler;
import me.craig.software.regen.common.objects.RSounds;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.acting.Acting;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.config.RegenConfig;
import me.craig.software.regen.handlers.ClientEvents;
import me.craig.software.regen.network.NetworkDispatcher;
import me.craig.software.regen.network.messages.SkinMessage;
import me.craig.software.regen.util.ClientUtil;
import me.craig.software.regen.util.RegenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;

class ClientActing
implements Acting {
    public static final Acting INSTANCE = new ClientActing();

    private ClientActing() {
    }

    @Override
    public void onRegenTick(IRegen cap) {
    }

    @Override
    public void onEnterGrace(IRegen cap) {
        if (cap.getLiving().func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            SoundEvent ambientSound = cap.getTimelordSound().getSound();
            ClientUtil.playSound(cap.getLiving(), ((SoundEvent)RSounds.HEART_BEAT.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.regenState().isGraceful(), 0.2f);
            ClientUtil.playSound(cap.getLiving(), ambientSound.getRegistryName(), SoundCategory.AMBIENT, true, () -> cap.regenState() != RegenStates.GRACE, 1.5f);
        }
    }

    @Override
    public void onHandsStartGlowing(IRegen cap) {
        if (cap.getLiving().func_200600_R() == EntityType.field_200729_aH) {
            ClientUtil.playSound(cap.getLiving(), ((SoundEvent)RSounds.HAND_GLOW.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> !cap.glowing(), 1.0f);
        }
    }

    @Override
    public void onRegenFinish(IRegen cap) {
        ClientEvents.shouldReset = false;
    }

    @Override
    public void onPerformingPost(IRegen cap) {
    }

    @Override
    public void onRegenTrigger(IRegen cap) {
        if (Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(cap.getLiving().func_110124_au())) {
            if (((Boolean)RegenConfig.CLIENT.changeMySkin.get()).booleanValue()) {
                if (cap.isNextSkinValid()) {
                    NetworkDispatcher.NETWORK_CHANNEL.sendToServer((Object)new SkinMessage(cap.nextSkin(), cap.isNextSkinTypeAlex()));
                    return;
                }
                Minecraft.func_71410_x().func_213165_a(() -> {
                    if (!cap.isNextSkinValid()) {
                        File file = CommonSkin.chooseRandomSkin(cap.getLiving().func_70681_au(), cap.preferredModel().isAlex(), false);
                        boolean isAlex = file.getAbsolutePath().contains(CommonSkin.SKIN_DIRECTORY_ALEX.getAbsolutePath());
                        Regeneration.LOG.info("Choosen Skin: " + file);
                        NetworkDispatcher.NETWORK_CHANNEL.sendToServer((Object)new SkinMessage(RegenUtil.fileToBytes(file), isAlex));
                    }
                });
            } else {
                SkinHandler.sendResetMessage();
            }
        }
    }

    @Override
    public void onGoCritical(IRegen cap) {
        if (Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(cap.getLiving().func_110124_au()) && cap.getLiving().func_200600_R() == EntityType.field_200729_aH) {
            ClientUtil.createToast(new TranslationTextComponent("regen.toast.enter_critical"), new TranslationTextComponent("regen.toast.enter_critical.sub", new Object[]{(Integer)RegenConfig.COMMON.criticalPhaseLength.get() / 60}));
            ClientUtil.playSound(cap.getLiving(), ((SoundEvent)RSounds.CRITICAL_STAGE.get()).getRegistryName(), SoundCategory.PLAYERS, true, () -> cap.regenState() != RegenStates.GRACE_CRIT, 1.0f);
        }
    }
}

