/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.regen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.craig.software.regen.common.advancement.TriggerManager;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.acting.ActingForwarder;
import me.craig.software.regen.common.regen.state.IStateManager;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.common.regen.transitions.TransitionType;
import me.craig.software.regen.common.regen.transitions.TransitionTypes;
import me.craig.software.regen.common.traits.AbstractTrait;
import me.craig.software.regen.common.traits.RegenTraitRegistry;
import me.craig.software.regen.config.RegenConfig;
import me.craig.software.regen.network.NetworkDispatcher;
import me.craig.software.regen.network.messages.SyncMessage;
import me.craig.software.regen.util.PlayerUtil;
import me.craig.software.regen.util.RegenSources;
import me.craig.software.regen.util.schedule.RegenScheduledAction;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class RegenCap
implements IRegen {
    @CapabilityInject(value=IRegen.class)
    public static final Capability<IRegen> CAPABILITY = null;
    private final StateManager stateManager;
    private final LivingEntity livingEntity;
    private boolean didSetup = false;
    private float primaryRed = 0.69411767f;
    private float primaryGreen = 0.74509805f;
    private float primaryBlue = 0.23529412f;
    private float secondaryRed = 0.7137255f;
    private float secondaryGreen = 0.75686276f;
    private float secondaryBlue = 0.25490198f;
    private boolean isAlex = false;
    private byte[] skinArray = new byte[0];
    private int regensLeft = 0;
    private int animationTicks = 0;
    private String deathMessage = "";
    private RegenStates currentState = RegenStates.ALIVE;
    private TransitionType transitionType = (TransitionType)TransitionTypes.FIERY.get();
    private boolean areHandsGlowing = false;
    private boolean traitActive = true;
    private PlayerUtil.SkinType preferredSkinType = PlayerUtil.SkinType.ALEX;
    private boolean nextSkinTypeAlex = false;
    private byte[] nextSkin = new byte[0];
    private AbstractTrait currentTrait = (AbstractTrait)RegenTraitRegistry.BORING.get();
    private AbstractTrait nextTrait = (AbstractTrait)RegenTraitRegistry.BORING.get();
    private IRegen.TimelordSound timelordSound = IRegen.TimelordSound.HUM;
    private IRegen.Hand handState = IRegen.Hand.NO_GONE;

    public RegenCap() {
        this.livingEntity = null;
        this.stateManager = null;
    }

    public RegenCap(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
        this.stateManager = !livingEntity.field_70170_p.field_72995_K ? new StateManager() : null;
    }

    @Nonnull
    public static LazyOptional<IRegen> get(LivingEntity player) {
        return player.getCapability(CAPABILITY, null);
    }

    @Override
    public int regens() {
        return this.regensLeft;
    }

    @Override
    public void setRegens(int regens) {
        this.regensLeft = regens;
    }

    @Override
    public void tick() {
        if (!this.livingEntity.field_70170_p.field_72995_K) {
            if (!this.didSetup) {
                this.syncToClients(null);
                this.didSetup = true;
            }
            if (this.traitActive) {
                this.currentTrait.tick(this);
            }
            if (this.stateManager != null && this.currentState != RegenStates.ALIVE) {
                this.stateManager.tick();
            }
            if (this.currentState == RegenStates.REGENERATING) {
                ++this.animationTicks;
                this.transitionType.onUpdateMidRegen(this);
                this.syncToClients(null);
                return;
            }
            this.animationTicks = 0;
        }
    }

    @Override
    public int updateTicks() {
        return this.animationTicks;
    }

    @Override
    public void setUpdateTicks(int animationTicks) {
        this.animationTicks = animationTicks;
    }

    @Override
    public boolean canRegenerate() {
        if (this.livingEntity != null) {
            return this.regens() > 0 && this.livingEntity.func_226278_cu_() > 0.0 && this.currentState != RegenStates.POST;
        }
        return false;
    }

    @Override
    public boolean glowing() {
        return this.areHandsGlowing;
    }

    @Override
    public RegenStates regenState() {
        return this.currentState;
    }

    @Override
    public StateManager stateManager() {
        return this.stateManager;
    }

    @Override
    public void readStyle(CompoundNBT colors) {
        this.primaryRed = colors.func_74760_g("p_red");
        this.primaryGreen = colors.func_74760_g("p_green");
        this.primaryBlue = colors.func_74760_g("p_blue");
        this.secondaryRed = colors.func_74760_g("s_red");
        this.secondaryGreen = colors.func_74760_g("s_green");
        this.secondaryBlue = colors.func_74760_g("s_blue");
    }

    @Override
    public CompoundNBT getOrWriteStyle() {
        CompoundNBT colors = new CompoundNBT();
        colors.func_74776_a("p_red", this.primaryRed);
        colors.func_74776_a("p_green", this.primaryGreen);
        colors.func_74776_a("p_blue", this.primaryBlue);
        colors.func_74776_a("s_red", this.secondaryRed);
        colors.func_74776_a("s_green", this.secondaryGreen);
        colors.func_74776_a("s_blue", this.secondaryBlue);
        return colors;
    }

    @Override
    public void extractRegens(int amount) {
        this.regensLeft -= amount;
    }

    @Override
    public void addRegens(int amount) {
        this.regensLeft += amount;
    }

    @Override
    public LivingEntity getLiving() {
        return this.livingEntity;
    }

    @Override
    public void syncToClients(@Nullable ServerPlayerEntity serverPlayerEntity) {
        if (this.livingEntity != null && this.livingEntity.field_70170_p.field_72995_K) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        this.areHandsGlowing = this.regenState().isGraceful() && this.stateManager.handGlowTimer.getTransition() == RegenStates.Transition.HAND_GLOW_TRIGGER;
        CompoundNBT nbt = this.serializeNBT();
        nbt.func_82580_o("state_manager");
        if (serverPlayerEntity == null) {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncMessage(this.livingEntity.func_145782_y(), nbt));
        } else {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayerEntity), (Object)new SyncMessage(this.livingEntity.func_145782_y(), nbt));
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("regens_left", this.regens());
        compoundNBT.func_74778_a("current_state", this.regenState().name());
        compoundNBT.func_74768_a("ticks_animating", this.updateTicks());
        compoundNBT.func_74778_a("transition_type", this.transitionType.getRegistryName().toString());
        compoundNBT.func_74778_a("model_pref", this.preferredModel().name());
        compoundNBT.func_74757_a("is_alex", this.currentlyAlex());
        compoundNBT.func_74757_a("glowing", this.glowing());
        compoundNBT.func_74778_a("current_trait", this.currentTrait.getRegistryName().toString());
        compoundNBT.func_74778_a("next_trait", this.nextTrait.getRegistryName().toString());
        compoundNBT.func_74778_a("sound_scheme", this.getTimelordSound().name());
        compoundNBT.func_74778_a("hand_state", this.handState().name());
        compoundNBT.func_74757_a("is_trait_active", this.traitActive);
        compoundNBT.func_74757_a("next_is_alex", this.isNextSkinTypeAlex());
        if (this.isSkinValidForUse()) {
            compoundNBT.func_74773_a("skin", this.skin());
        }
        if (this.isNextSkinValid()) {
            compoundNBT.func_74773_a("next_skin", this.nextSkin());
        }
        if (!this.livingEntity.field_70170_p.field_72995_K && this.stateManager != null) {
            compoundNBT.func_218657_a("state_manager", (INBT)this.stateManager.serializeNBT());
        }
        compoundNBT.func_218657_a("colors", (INBT)this.getOrWriteStyle());
        return compoundNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setRegens(nbt.func_74762_e("regens_left"));
        this.currentState = nbt.func_74764_b("current_state") ? RegenStates.valueOf(nbt.func_74779_i("current_state")) : RegenStates.ALIVE;
        this.setUpdateTicks(nbt.func_74762_e("ticks_animating"));
        this.setSkin(nbt.func_74770_j("skin"));
        this.setNextSkin(nbt.func_74770_j("next_skin"));
        this.setAlexSkin(nbt.func_74767_n("is_alex"));
        this.traitActive = nbt.func_74767_n("is_trait_active");
        this.setNextSkinType(nbt.func_74767_n("next_is_alex"));
        if (nbt.func_74764_b("sound_scheme")) {
            this.setTimelordSound(IRegen.TimelordSound.valueOf(nbt.func_74779_i("sound_scheme")));
        }
        if (nbt.func_74764_b("hand_state")) {
            this.setHandState(IRegen.Hand.valueOf(nbt.func_74779_i("hand_state")));
        }
        this.areHandsGlowing = nbt.func_74767_n("glowing");
        this.setTrait(RegenTraitRegistry.fromID(nbt.func_74779_i("current_trait")));
        this.setNextTrait(RegenTraitRegistry.fromID(nbt.func_74779_i("next_trait")));
        if (nbt.func_74764_b("model_pref")) {
            this.setPreferredModel(PlayerUtil.SkinType.valueOf(nbt.func_74779_i("model_pref")));
        }
        if (nbt.func_74764_b("transition_type")) {
            this.transitionType = (TransitionType)TransitionTypes.TRANSITION_TYPES_REGISTRY.get().getValue(new ResourceLocation(nbt.func_74779_i("transition_type")));
        }
        if (nbt.func_74764_b("state_manager") && this.stateManager != null) {
            this.stateManager.deserializeNBT((CompoundNBT)nbt.func_74781_a("state_manager"));
        }
        if (nbt.func_74764_b("colors")) {
            this.readStyle((CompoundNBT)nbt.func_74781_a("colors"));
        }
    }

    @Override
    public TransitionType transitionType() {
        return this.transitionType;
    }

    @Override
    public void setTransitionType(TransitionType transitionType) {
        this.transitionType = transitionType;
    }

    @Override
    public String deathMessage() {
        return this.deathMessage;
    }

    @Override
    public void setDeathMessage(String deathMessage) {
        this.deathMessage = deathMessage;
    }

    @Override
    public void forceRegeneration() {
        if (this.livingEntity != null) {
            this.livingEntity.func_70097_a(RegenSources.REGEN_DMG_FORCED, 2.1474836E9f);
        }
    }

    @Override
    public byte[] skin() {
        return this.skinArray;
    }

    @Override
    public void setSkin(byte[] skin) {
        this.skinArray = skin;
    }

    @Override
    public boolean isSkinValidForUse() {
        return !Arrays.equals(this.skinArray, new byte[0]);
    }

    @Override
    public Vector3d getPrimaryColors() {
        return new Vector3d((double)this.primaryRed, (double)this.primaryGreen, (double)this.primaryBlue);
    }

    @Override
    public Vector3d getSecondaryColors() {
        return new Vector3d((double)this.secondaryRed, (double)this.secondaryGreen, (double)this.secondaryBlue);
    }

    @Override
    public boolean currentlyAlex() {
        return this.isAlex;
    }

    @Override
    public void setAlexSkin(boolean isAlex) {
        this.isAlex = isAlex;
    }

    @Override
    public PlayerUtil.SkinType preferredModel() {
        return this.preferredSkinType;
    }

    @Override
    public void setPreferredModel(PlayerUtil.SkinType skinType) {
        this.preferredSkinType = skinType;
    }

    @Override
    public byte[] nextSkin() {
        return this.nextSkin;
    }

    @Override
    public void setNextSkin(byte[] bytes) {
        this.nextSkin = bytes;
    }

    @Override
    public boolean isNextSkinValid() {
        return !Arrays.equals(this.nextSkin, new byte[0]);
    }

    @Override
    public void setNextSkinType(boolean isAlex) {
        this.nextSkinTypeAlex = isAlex;
    }

    @Override
    public boolean isNextSkinTypeAlex() {
        return this.nextSkinTypeAlex;
    }

    @Override
    public AbstractTrait trait() {
        return this.currentTrait;
    }

    @Override
    public boolean traitActive() {
        return this.traitActive;
    }

    @Override
    public void toggleTrait() {
        this.traitActive = !this.traitActive;
    }

    @Override
    public void setTrait(AbstractTrait trait) {
        this.currentTrait = trait;
    }

    @Override
    public AbstractTrait getNextTrait() {
        return this.nextTrait;
    }

    @Override
    public void setNextTrait(AbstractTrait trait) {
        this.nextTrait = trait;
    }

    @Override
    public IRegen.TimelordSound getTimelordSound() {
        return this.timelordSound;
    }

    @Override
    public void setTimelordSound(IRegen.TimelordSound timelordSound) {
        this.timelordSound = timelordSound;
    }

    @Override
    public IRegen.Hand handState() {
        return this.handState;
    }

    @Override
    public void setHandState(IRegen.Hand handState) {
        this.handState = handState;
    }

    public class StateManager
    implements IStateManager {
        private final Map<RegenStates.Transition, Runnable> transitionCallbacks = new HashMap<RegenStates.Transition, Runnable>();
        private RegenScheduledAction nextTransition;
        private RegenScheduledAction handGlowTimer;

        private StateManager() {
            this.transitionCallbacks.put(RegenStates.Transition.ENTER_CRITICAL, this::enterCriticalPhase);
            this.transitionCallbacks.put(RegenStates.Transition.CRITICAL_DEATH, () -> this.midSequenceKill(true));
            this.transitionCallbacks.put(RegenStates.Transition.FINISH_REGENERATION, this::finishRegeneration);
            this.transitionCallbacks.put(RegenStates.Transition.END_POST, this::endPost);
            Runnable err = () -> {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            };
            this.transitionCallbacks.put(RegenStates.Transition.HAND_GLOW_START, err);
            this.transitionCallbacks.put(RegenStates.Transition.HAND_GLOW_TRIGGER, err);
        }

        private void scheduleTransitionInTicks(RegenStates.Transition transition, long inTicks) {
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting non-completed/cancelled transition: \n Attempted Transition: " + transition.name() + "\n Current: " + this.nextTransition.transition.name() + "\n Affected Player: " + RegenCap.this.livingEntity.func_200200_C_());
            }
            if (transition == RegenStates.Transition.HAND_GLOW_START || transition == RegenStates.Transition.HAND_GLOW_TRIGGER) {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            }
            this.nextTransition = new RegenScheduledAction(transition, RegenCap.this.livingEntity, this.transitionCallbacks.get((Object)transition), inTicks);
        }

        private void scheduleTransitionInSeconds(RegenStates.Transition transition, long inSeconds) {
            this.scheduleTransitionInTicks(transition, inSeconds * 20L);
        }

        private void scheduleNextHandGlow() {
            if (RegenCap.this.currentState.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with new next hand glow");
            }
            this.handGlowTimer = new RegenScheduledAction(RegenStates.Transition.HAND_GLOW_START, RegenCap.this.livingEntity, this::scheduleHandGlowTrigger, (Integer)RegenConfig.COMMON.handGlowInterval.get() * 20);
            RegenCap.this.syncToClients(null);
        }

        private void scheduleHandGlowTrigger() {
            if (RegenCap.this.currentState.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with trigger timer prematurely");
            }
            this.handGlowTimer = new RegenScheduledAction(RegenStates.Transition.HAND_GLOW_TRIGGER, RegenCap.this.livingEntity, this::triggerRegeneration, (Integer)RegenConfig.COMMON.handGlowTriggerDelay.get() * 20);
            ActingForwarder.onHandsStartGlowing(RegenCap.this);
            RegenCap.this.syncToClients(null);
        }

        @Override
        public boolean onKilled(DamageSource source) {
            if (source == DamageSource.field_76368_d || source == DamageSource.field_191291_g) {
                return false;
            }
            if (source == RegenSources.REGEN_DMG_CRITICAL) {
                if (this.nextTransition != null) {
                    this.nextTransition.cancel();
                }
                return false;
            }
            switch (RegenCap.this.currentState) {
                case ALIVE: {
                    if (!RegenCap.this.canRegenerate()) {
                        return false;
                    }
                    this.scheduleTransitionInSeconds(RegenStates.Transition.ENTER_CRITICAL, ((Integer)RegenConfig.COMMON.gracePhaseLength.get()).intValue());
                    this.scheduleHandGlowTrigger();
                    RegenCap.this.currentState = RegenStates.GRACE;
                    RegenCap.this.syncToClients(null);
                    ActingForwarder.onEnterGrace(RegenCap.this);
                    return true;
                }
                case REGENERATING: {
                    if (this.nextTransition != null) {
                        this.nextTransition.cancel();
                    }
                    this.midSequenceKill(false);
                    return false;
                }
                case GRACE_CRIT: {
                    if (this.nextTransition != null) {
                        this.nextTransition.cancel();
                    }
                    if (source == RegenSources.REGEN_DMG_FORCED) {
                        this.triggerRegeneration();
                        return true;
                    }
                    this.midSequenceKill(true);
                    return false;
                }
                case POST: {
                    RegenCap.this.currentState = RegenStates.ALIVE;
                    if (this.nextTransition != null) {
                        this.nextTransition.cancel();
                    }
                    return false;
                }
                case GRACE: {
                    this.triggerRegeneration();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onPunchEntity(LivingHurtEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (RegenCap.this.currentState.isGraceful() && entity.func_110143_aJ() < entity.func_110138_aP() && RegenCap.this.glowing() && RegenCap.this.livingEntity.func_225608_bj_()) {
                float healthNeeded = entity.func_110138_aP() - entity.func_110143_aJ();
                entity.func_70691_i(healthNeeded);
                if (RegenCap.this.livingEntity instanceof PlayerEntity) {
                    PlayerUtil.sendMessage(RegenCap.this.livingEntity, (IFormattableTextComponent)new TranslationTextComponent("regen.messages.healed", new Object[]{entity.func_200200_C_()}), true);
                }
                event.setAmount(0.0f);
                RegenCap.this.livingEntity.func_70097_a(RegenSources.REGEN_DMG_HEALING, healthNeeded);
            }
        }

        @Override
        public void onPunchBlock(PlayerInteractEvent.LeftClickBlock e) {
            if (RegenCap.this.currentState.isGraceful() && RegenCap.this.glowing()) {
                BlockState block = e.getWorld().func_180495_p(e.getPos());
                if (block.func_177230_c() == Blocks.field_150433_aE || block.func_177230_c() == Blocks.field_196604_cC) {
                    e.getWorld().func_184133_a(null, e.getPos(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                if (e.getEntityLiving() instanceof ServerPlayerEntity) {
                    ServerPlayerEntity playerEntity = (ServerPlayerEntity)RegenCap.this.livingEntity;
                    TriggerManager.CHANGE_REFUSAL.trigger(playerEntity);
                }
                this.handGlowTimer.cancel();
                this.scheduleNextHandGlow();
                if (!e.getEntityLiving().field_70170_p.field_72995_K && e.getEntityLiving() instanceof PlayerEntity) {
                    PlayerUtil.sendMessage(e.getEntityLiving(), (IFormattableTextComponent)new TranslationTextComponent("regen.messages.regen_delayed"), true);
                }
                e.setCanceled(true);
            }
        }

        private void tick() {
            if (((RegenCap)RegenCap.this).livingEntity.field_70170_p.field_72995_K) {
                throw new IllegalStateException("Ticking state manager on the client");
            }
            if (RegenCap.this.currentState == RegenStates.ALIVE) {
                throw new IllegalStateException("Ticking dormant state manager (state == ALIVE)");
            }
            if (RegenCap.this.currentState.isGraceful()) {
                this.handGlowTimer.tick();
            }
            ActingForwarder.onRegenTick(RegenCap.this);
            if (this.nextTransition != null) {
                this.nextTransition.tick();
            }
            if (RegenCap.this.currentState == RegenStates.POST) {
                ActingForwarder.onPerformingPost(RegenCap.this);
            }
        }

        private void triggerRegeneration() {
            RegenCap.this.currentState = RegenStates.REGENERATING;
            if (((Boolean)RegenConfig.COMMON.sendRegenDeathMessages.get()).booleanValue() && RegenCap.this.livingEntity instanceof PlayerEntity) {
                TranslationTextComponent text = new TranslationTextComponent("regen.messages.regen_death_msg", new Object[]{RegenCap.this.livingEntity.func_200200_C_()});
                text.func_230530_a_(text.func_150256_b().func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(RegenCap.this.deathMessage()))));
                PlayerUtil.sendMessageToAll(text);
            }
            if (this.nextTransition != null) {
                this.nextTransition.cancel();
            }
            if (RegenCap.this.currentState.isGraceful()) {
                this.handGlowTimer.cancel();
            }
            this.scheduleTransitionInTicks(RegenStates.Transition.FINISH_REGENERATION, RegenCap.this.transitionType.getAnimationLength());
            ActingForwarder.onRegenTrigger(RegenCap.this);
            RegenCap.this.transitionType.onStartRegeneration(RegenCap.this);
            RegenCap.this.syncToClients(null);
        }

        private void enterCriticalPhase() {
            RegenCap.this.currentState = RegenStates.GRACE_CRIT;
            this.scheduleTransitionInSeconds(RegenStates.Transition.CRITICAL_DEATH, ((Integer)RegenConfig.COMMON.criticalPhaseLength.get()).intValue());
            ActingForwarder.onGoCritical(RegenCap.this);
            if (RegenCap.this.livingEntity instanceof ServerPlayerEntity) {
                ServerPlayerEntity playerEntity = (ServerPlayerEntity)RegenCap.this.livingEntity;
                TriggerManager.CRITICAL.trigger(playerEntity);
            }
            RegenCap.this.syncToClients(null);
        }

        private void midSequenceKill(boolean isGrace) {
            RegenCap.this.currentState = RegenStates.ALIVE;
            this.nextTransition = null;
            this.handGlowTimer = null;
            RegenCap.this.transitionType.onFinishRegeneration(RegenCap.this);
            RegenCap.this.livingEntity.func_70097_a(isGrace ? RegenSources.REGEN_DMG_CRITICAL : RegenSources.REGEN_DMG_KILLED, 2.1474836E9f);
            if (((Boolean)RegenConfig.COMMON.loseRegensOnDeath.get()).booleanValue()) {
                RegenCap.this.extractRegens(RegenCap.this.regens());
            }
            RegenCap.this.setTrait((AbstractTrait)RegenTraitRegistry.BORING.get());
            RegenCap.this.setSkin(new byte[0]);
            RegenCap.this.syncToClients(null);
        }

        private void endPost() {
            RegenCap.this.currentState = RegenStates.ALIVE;
            RegenCap.this.syncToClients(null);
            this.nextTransition = null;
            if (RegenCap.this.livingEntity instanceof PlayerEntity) {
                PlayerUtil.sendMessage(RegenCap.this.livingEntity, (IFormattableTextComponent)new TranslationTextComponent("regen.messages.post_ended"), true);
            }
            RegenCap.this.handState = IRegen.Hand.NO_GONE;
        }

        private void finishRegeneration() {
            RegenCap.this.currentState = RegenStates.POST;
            this.scheduleTransitionInSeconds(RegenStates.Transition.END_POST, ((RegenCap)RegenCap.this).livingEntity.field_70170_p.field_73012_v.nextInt(300) + 10);
            this.handGlowTimer = null;
            RegenCap.this.transitionType.onFinishRegeneration(RegenCap.this);
            ActingForwarder.onRegenFinish(RegenCap.this);
            RegenCap.this.syncToClients(null);
        }

        @Override
        @Deprecated
        public Pair<RegenStates.Transition, Long> getScheduledEvent() {
            return this.nextTransition == null ? null : Pair.of((Object)((Object)this.nextTransition.transition), (Object)this.nextTransition.getTicksLeft());
        }

        @Override
        @Deprecated
        public void skip() {
            while (!this.nextTransition.tick()) {
            }
        }

        @Override
        @Deprecated
        public void fastForwardHandGlow() {
            while (!this.handGlowTimer.tick()) {
            }
        }

        @Override
        public double stateProgress() {
            if (this.nextTransition != null) {
                return this.nextTransition.getProgress();
            }
            return 0.0;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() >= 0L) {
                nbt.func_74778_a("transitionId", this.nextTransition.transition.toString());
                nbt.func_74772_a("transitionInTicks", this.nextTransition.getTicksLeft());
            }
            if (this.handGlowTimer != null && this.handGlowTimer.getTicksLeft() >= 0L) {
                nbt.func_74778_a("handGlowState", this.handGlowTimer.transition.toString());
                nbt.func_74772_a("handGlowScheduledTicks", this.handGlowTimer.getTicksLeft());
            }
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b("transitionId")) {
                this.scheduleTransitionInTicks(RegenStates.Transition.valueOf(nbt.func_74779_i("transitionId")), nbt.func_74763_f("transitionInTicks"));
            }
            if (nbt.func_74764_b("handGlowState")) {
                Runnable callback;
                RegenStates.Transition transition = RegenStates.Transition.valueOf(nbt.func_74779_i("handGlowState"));
                switch (transition) {
                    case HAND_GLOW_START: {
                        callback = this::scheduleHandGlowTrigger;
                        break;
                    }
                    case HAND_GLOW_TRIGGER: {
                        callback = this::triggerRegeneration;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal hand glow timer transition");
                    }
                }
                this.handGlowTimer = new RegenScheduledAction(transition, RegenCap.this.livingEntity, callback, nbt.func_74763_f("handGlowScheduledTicks"));
            }
        }
    }
}

