/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.objects;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import me.craig.software.regen.common.item.FobWatchItem;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.config.RegenConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RGlobalLoot {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> GLM = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"regen");
    public static final RegistryObject<RegenerationLoot.Serializer> REGEN_LOOT = GLM.register("loot", () -> new RegenerationLoot.Serializer());

    public static ItemStack createBrokenFob(Random random) {
        ItemStack itemStack = new ItemStack((IItemProvider)RItems.FOB.get());
        FobWatchItem.setEngrave(itemStack, random.nextBoolean());
        itemStack.func_196085_b(random.nextInt((Integer)RegenConfig.COMMON.regenCapacity.get()));
        return itemStack;
    }

    public static class RegenerationLoot
    extends LootModifier {
        private final int chance;

        public RegenerationLoot(ILootCondition[] conditionsIn, int chance) {
            super(conditionsIn);
            this.chance = chance;
        }

        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (context.func_216032_b().nextInt(100) <= this.chance && ((Boolean)RegenConfig.COMMON.genFobLoot.get()).booleanValue()) {
                generatedLoot.add(RGlobalLoot.createBrokenFob(context.func_216032_b()));
            }
            return generatedLoot;
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<RegenerationLoot> {
            private Serializer() {
            }

            public RegenerationLoot read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
                int multiplicationFactor = JSONUtils.func_151208_a((JsonObject)object, (String)"chance", (int)2);
                return new RegenerationLoot(conditions, multiplicationFactor);
            }

            public JsonObject write(RegenerationLoot instance) {
                JsonObject obj = this.makeConditions(instance.conditions);
                obj.addProperty("chance", (Number)instance.chance);
                return obj;
            }
        }
    }
}

