/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.item;

import me.craig.software.regen.common.entities.TimelordEntity;
import me.craig.software.regen.common.objects.REntities;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SpawnItem<E extends TimelordEntity>
extends Item {
    public SpawnItem() {
        super(new Item.Properties().func_200916_a(RItems.MAIN));
    }

    public static void setType(ItemStack stack, Timelord type) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74778_a("type", type.name());
    }

    public static Timelord getType(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        String timelordType = tag.func_74779_i("type");
        timelordType = timelordType.isEmpty() ? Timelord.FEMALE_COUNCIL.name() : timelordType;
        return Timelord.valueOf(timelordType);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (Timelord timelordType : Timelord.values()) {
                ItemStack itemstack = new ItemStack((IItemProvider)this);
                SpawnItem.setType(itemstack, timelordType);
                items.add((Object)itemstack);
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        Timelord name = SpawnItem.getType(stack);
        return new TranslationTextComponent("regen.timelord_type." + name.name().toLowerCase());
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        Hand hand = player.func_184600_cs();
        if (!worldIn.field_72995_K) {
            TimelordEntity timelord = (TimelordEntity)((EntityType)REntities.TIMELORD.get()).func_200721_a(worldIn);
            timelord.setMale(SpawnItem.getType(context.func_195996_i()).isMale());
            if (SpawnItem.getType(context.func_195996_i()) == Timelord.GUARD) {
                timelord.setTimelordType(TimelordEntity.TimelordType.GUARD);
            } else {
                timelord.setTimelordType(TimelordEntity.TimelordType.COUNCIL);
            }
            RegenCap.get((LivingEntity)timelord).ifPresent(iRegen -> {
                timelord.initSkin((IRegen)iRegen);
                timelord.genName();
                iRegen.setRegens(12);
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74776_a("p_red", (float)field_77697_d.nextInt(255) / 255.0f);
                nbt.func_74776_a("p_green", (float)field_77697_d.nextInt(255) / 255.0f);
                nbt.func_74776_a("p_blue", (float)field_77697_d.nextInt(255) / 255.0f);
                nbt.func_74776_a("s_red", (float)field_77697_d.nextInt(255) / 255.0f);
                nbt.func_74776_a("s_green", (float)field_77697_d.nextInt(255) / 255.0f);
                nbt.func_74776_a("s_blue", (float)field_77697_d.nextInt(255) / 255.0f);
                iRegen.readStyle(nbt);
            });
            timelord.setup();
            timelord.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            timelord.func_70625_a((Entity)player, 90.0f, 90.0f);
            player.func_184586_b(hand).func_190918_g(1);
            worldIn.func_217376_c((Entity)timelord);
            if (!player.func_184812_l_()) {
                context.func_195996_i().func_190918_g(1);
            }
        }
        return super.func_195939_a(context);
    }

    public static enum Timelord {
        FEMALE_COUNCIL(false),
        MALE_COUNCIL(true),
        GUARD(false);

        private final boolean isMale;

        private Timelord(boolean b) {
            this.isMale = b;
        }

        public boolean isMale() {
            return this == GUARD ? field_77697_d.nextBoolean() : this.isMale;
        }
    }
}

