/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.item;

import java.util.List;
import java.util.UUID;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.traits.AbstractTrait;
import me.craig.software.regen.common.traits.RegenTraitRegistry;
import me.craig.software.regen.util.PlayerUtil;
import me.craig.software.regen.util.RegenSources;
import me.craig.software.regen.util.RegenUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import org.jetbrains.annotations.Nullable;

public class HandItem
extends Item {
    public HandItem(Item.Properties properties) {
        super(properties);
    }

    public static void setSkinType(PlayerUtil.SkinType skinType, ItemStack stack) {
        stack.func_196082_o().func_74757_a("is_alex", skinType.isAlex());
    }

    public static void setSkin(byte[] skin, ItemStack stack) {
        stack.func_196082_o().func_74773_a("skin", skin);
    }

    public static byte[] getSkin(ItemStack stack) {
        return stack.func_196082_o().func_74770_j("skin");
    }

    public static boolean isAlex(ItemStack stack) {
        return stack.func_196082_o().func_74767_n("is_alex");
    }

    public static void setTrait(AbstractTrait traitBase, ItemStack stack) {
        stack.func_196082_o().func_74778_a("trait", traitBase.getRegistryName().toString());
    }

    public static AbstractTrait getTrait(ItemStack stack) {
        return RegenTraitRegistry.fromID(stack.func_196082_o().func_74779_i("trait"));
    }

    public static void setEnergy(float energy, ItemStack stack) {
        stack.func_196082_o().func_74776_a("energy", energy);
    }

    public static float getEnergy(ItemStack stack) {
        return stack.func_196082_o().func_74760_g("energy");
    }

    public static void setUUID(UUID uuid, ItemStack stack) {
        stack.func_196082_o().func_186854_a("user", uuid);
    }

    public static UUID getUUID(ItemStack stack) {
        if (stack.func_196082_o().func_74764_b("user")) {
            return stack.func_196082_o().func_186857_a("user");
        }
        return null;
    }

    public static void createHand(LivingEntity livingEntity) {
        ItemStack itemStack = new ItemStack((IItemProvider)RItems.HAND.get());
        RegenCap.get(livingEntity).ifPresent(iRegen -> {
            HandItem.setUUID(livingEntity.func_110124_au(), itemStack);
            HandItem.setSkinType(iRegen.currentlyAlex() ? PlayerUtil.SkinType.ALEX : PlayerUtil.SkinType.STEVE, itemStack);
            HandItem.setTrait(iRegen.trait(), itemStack);
            HandItem.setEnergy(0.0f, itemStack);
            if (iRegen.isSkinValidForUse()) {
                HandItem.setSkin(iRegen.skin(), itemStack);
            }
            iRegen.setHandState(IRegen.Hand.LEFT_GONE);
        });
        livingEntity.func_70097_a(RegenSources.REGEN_DMG_HAND, 3.0f);
        InventoryHelper.func_180173_a((World)livingEntity.field_70170_p, (double)livingEntity.func_226277_ct_(), (double)livingEntity.func_226278_cu_(), (double)livingEntity.func_226281_cx_(), (ItemStack)itemStack);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (stack.func_196082_o().func_74764_b("user")) {
            return new TranslationTextComponent("item.regen.hand_with_arg", new Object[]{UsernameCache.getLastKnownUsername((UUID)HandItem.getUUID(stack)) + "'s"});
        }
        return super.func_200295_i(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (PlayerUtil.SkinType skinType : PlayerUtil.SkinType.values()) {
                if (skinType == PlayerUtil.SkinType.EITHER) continue;
                ItemStack itemstack = new ItemStack((IItemProvider)this);
                HandItem.setSkinType(skinType, itemstack);
                items.add((Object)itemstack);
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + "Trait: %s", new Object[]{TextFormatting.GRAY + TextFormatting.ITALIC.toString() + HandItem.getTrait(stack).translation().getString()}));
        tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + "Energy: %s", new Object[]{TextFormatting.GRAY + TextFormatting.ITALIC.toString() + RegenUtil.round(HandItem.getEnergy(stack), 2)}));
    }
}

