/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.item;

import me.craig.software.regen.common.entities.LaserProjectile;
import me.craig.software.regen.common.objects.REntities;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.common.objects.RSounds;
import me.craig.software.regen.util.RegenSources;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GunItem
extends Item {
    private final int cooldown;
    private final float damage;

    public GunItem(int shotsPerRound, int cooldown, float damage) {
        super(new Item.Properties().func_200916_a(RItems.MAIN).func_200918_c(shotsPerRound).setNoRepair());
        this.cooldown = cooldown;
        this.damage = damage;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return super.func_195939_a(context);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            boolean isPistol;
            PlayerEntity playerIn = (PlayerEntity)entityLiving;
            boolean bl = isPistol = this == RItems.PISTOL.get();
            if (this.hasAmmo(entityLiving, stack) && stack.func_77952_i() < stack.func_77958_k() && !playerIn.func_184811_cZ().func_185141_a((Item)this)) {
                worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), isPistol ? (SoundEvent)RSounds.RIFLE.get() : (SoundEvent)RSounds.STASER.get(), SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                playerIn.func_184811_cZ().func_185145_a((Item)this, this.cooldown);
                if (worldIn.field_73012_v.nextInt(40) < 10 && !playerIn.func_184812_l_()) {
                    this.setDamage(stack, this.getDamage(stack) + 10);
                }
                if (!worldIn.field_72995_K) {
                    LaserProjectile laserProjectile = new LaserProjectile((EntityType<? extends ThrowableEntity>)((EntityType)REntities.LASER.get()), (LivingEntity)playerIn, worldIn);
                    laserProjectile.setDamage(this.damage);
                    laserProjectile.setDamageSource(isPistol ? RegenSources.REGEN_DMG_STASER : RegenSources.REGEN_DMG_RIFLE);
                    laserProjectile.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
                    entityLiving.func_184185_a(isPistol ? (SoundEvent)RSounds.STASER.get() : (SoundEvent)RSounds.RIFLE.get(), 1.0f, 0.4f / (worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    worldIn.func_217376_c((Entity)laserProjectile);
                }
            }
        }
    }

    private boolean hasAmmo(LivingEntity entityLiving, ItemStack gun) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)entityLiving;
            if (playerEntity.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)gun) > 0) {
                return true;
            }
            for (ItemStack itemStack : playerEntity.field_71071_by.field_70462_a) {
                if (itemStack.func_77973_b() != RItems.PLASMA_CARTRIDGE.get()) continue;
                itemStack.func_190918_g(1);
                return true;
            }
            playerEntity.func_184811_cZ().func_185145_a((Item)this, 10);
            playerEntity.func_184185_a((SoundEvent)RSounds.GUN_EMPTY.get(), 1.0f, 1.0f);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public float getDamage() {
        return this.damage;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return p_82789_2_.func_77973_b() == RItems.ZINC.get();
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return false;
    }
}

