/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.item;

import me.craig.software.regen.Regeneration;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.common.objects.RParticles;
import me.craig.software.regen.common.objects.RSounds;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.config.RegenConfig;
import me.craig.software.regen.util.ClientUtil;
import me.craig.software.regen.util.PlayerUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FobWatchItem
extends Item {
    public FobWatchItem() {
        super(new Item.Properties().setNoRepair().func_200916_a(RItems.MAIN).func_200917_a(1));
    }

    public static CompoundNBT getStackTag(ItemStack stack) {
        CompoundNBT stackTag = stack.func_196082_o();
        if (!stackTag.func_74764_b("is_open") || !stackTag.func_74764_b("is_gold")) {
            stackTag.func_74757_a("is_open", false);
            stackTag.func_74757_a("is_gold", field_77697_d.nextBoolean());
        }
        return stackTag;
    }

    public static boolean getEngrave(ItemStack stack) {
        return FobWatchItem.getStackTag(stack).func_74767_n("is_gold");
    }

    public static void setEngrave(ItemStack stack, boolean isGold) {
        FobWatchItem.getStackTag(stack).func_74757_a("is_gold", isGold);
    }

    public static boolean isOpen(ItemStack stack) {
        return FobWatchItem.getStackTag(stack).func_74767_n("is_open");
    }

    public static void setOpen(ItemStack stack, boolean isOpen) {
        FobWatchItem.getStackTag(stack).func_74757_a("is_open", isOpen);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        this.setDamage(stack, 0);
        FobWatchItem.setOpen(stack, false);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77973_b() instanceof FobWatchItem && FobWatchItem.isOpen(stack) && entityIn.field_70173_aa % 600 == 0) {
            FobWatchItem.setOpen(stack, false);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IRegen cap = (IRegen)RegenCap.get((LivingEntity)player).orElseGet(null);
        if (!player.func_225608_bj_()) {
            if (this.getDamage(stack) == ((Integer)RegenConfig.COMMON.regenCapacity.get()).intValue() && (Integer)RegenConfig.COMMON.regenCapacity.get() != 0) {
                return this.msgUsageFailed(player, "regen.messages.transfer.empty_watch", stack);
            }
            if (cap.regens() == ((Integer)RegenConfig.COMMON.regenCapacity.get()).intValue()) {
                return this.msgUsageFailed(player, "regen.messages.transfer.max_regens", stack);
            }
            int supply = (Integer)RegenConfig.COMMON.regenCapacity.get() - this.getDamage(stack);
            int needed = (Integer)RegenConfig.COMMON.regenCapacity.get() - cap.regens();
            int used = Math.min(supply, needed);
            if ((Integer)RegenConfig.COMMON.regenCapacity.get() == 0) {
                supply = 12;
            }
            if (cap.canRegenerate()) {
                FobWatchItem.setOpen(stack, true);
                PlayerUtil.sendMessage((LivingEntity)player, (IFormattableTextComponent)new TranslationTextComponent("regen.messages.gained_regens", new Object[]{used}), true);
            } else if (!world.field_72995_K) {
                FobWatchItem.setOpen(stack, true);
                PlayerUtil.sendMessage((LivingEntity)player, (IFormattableTextComponent)new TranslationTextComponent("regen.messages.now_timelord"), true);
            }
            if (!world.func_201670_d()) {
                ServerWorld serverWorld = (ServerWorld)world;
                BlockPos blockPos = player.func_233580_cy_();
                serverWorld.func_195598_a((IParticleData)((BasicParticleType)RParticles.CONTAINER.get()), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o() + 1.0, (double)blockPos.func_177952_p(), 8, 0.5, 0.25, 0.5, 0.0);
            }
            if (used < 0) {
                Regeneration.LOG.warn(player.func_200200_C_().getString() + ": Fob watch used <0 regens (supply: " + supply + ", needed:" + needed + ", used:" + used + ", capacity:" + RegenConfig.COMMON.regenCapacity.get() + ", damage:" + this.getDamage(stack) + ", regens:" + cap.regens());
            }
            this.setDamage(stack, stack.func_77952_i() + used);
            if (world.field_72995_K) {
                ClientUtil.playPositionedSoundRecord((SoundEvent)RSounds.FOB_WATCH.get(), 1.0f, 2.0f);
            } else {
                FobWatchItem.setOpen(stack, true);
                cap.addRegens(used);
            }
        } else {
            if (!cap.canRegenerate()) {
                return this.msgUsageFailed(player, "regen.messages.transfer.no_regens", stack);
            }
            if (cap.regenState() != RegenStates.ALIVE) {
                return this.msgUsageFailed(player, "regen.messages.not_alive", stack);
            }
            if (this.getDamage(stack) == 0) {
                return this.msgUsageFailed(player, "regen.messages.transfer.full_watch", stack);
            }
            this.setDamage(stack, this.getDamage(stack) - 1);
            PlayerUtil.sendMessage((LivingEntity)player, "regen.messages.transfer.success", true);
            if (world.field_72995_K) {
                ClientUtil.playPositionedSoundRecord(SoundEvents.field_187646_bt, 5.0f, 2.0f);
            } else {
                FobWatchItem.setOpen(stack, true);
                cap.extractRegens(1);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private ActionResult<ItemStack> msgUsageFailed(PlayerEntity player, String message, ItemStack stack) {
        PlayerUtil.sendMessage((LivingEntity)player, message, true);
        return ActionResult.func_226251_d_((Object)stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean func_77645_m() {
        return super.func_77645_m();
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)RegenConfig.COMMON.regenCapacity.get();
    }

    public void func_150895_a(ItemGroup itemGroup, NonNullList<ItemStack> stackList) {
        if (this.func_194125_a(itemGroup)) {
            ItemStack itemStack = new ItemStack((IItemProvider)this);
            this.setDamage(itemStack, 0);
            stackList.add((Object)itemStack);
        }
    }
}

