/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.entities;

import java.io.File;
import java.util.Random;
import me.craig.software.regen.client.skin.CommonSkin;
import me.craig.software.regen.common.advancement.TriggerManager;
import me.craig.software.regen.common.entities.LaserProjectile;
import me.craig.software.regen.common.entities.TimelordAttackGoal;
import me.craig.software.regen.common.item.ElixirItem;
import me.craig.software.regen.common.item.SpawnItem;
import me.craig.software.regen.common.objects.REntities;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.common.objects.RSounds;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.common.regen.transitions.TransitionTypes;
import me.craig.software.regen.common.traits.AbstractTrait;
import me.craig.software.regen.common.traits.RegenTraitRegistry;
import me.craig.software.regen.config.RegenConfig;
import me.craig.software.regen.network.NetworkDispatcher;
import me.craig.software.regen.network.messages.RemoveTimelordSkinMessage;
import me.craig.software.regen.util.RegenSources;
import me.craig.software.regen.util.RegenUtil;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TimelordEntity
extends AbstractVillagerEntity
implements IRangedAttackMob {
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(TimelordEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> AIMING = EntityDataManager.func_187226_a(TimelordEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_MALE = EntityDataManager.func_187226_a(TimelordEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_SETUP = EntityDataManager.func_187226_a(TimelordEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> AIMING_TICKS = EntityDataManager.func_187226_a(TimelordEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected final SwimmerPathNavigator waterNavigator;
    protected final GroundPathNavigator groundNavigator;

    public TimelordEntity(World world) {
        this((EntityType<TimelordEntity>)((EntityType)REntities.TIMELORD.get()), world);
    }

    public TimelordEntity(EntityType<TimelordEntity> entityEntityType, World world) {
        super(entityEntityType, world);
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, world);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    public VillagerEntity getBreedOffspring(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TYPE, (Object)(this.field_70146_Z.nextBoolean() ? TimelordType.COUNCIL.name() : TimelordType.GUARD.name()));
        this.func_184212_Q().func_187214_a(AIMING, (Object)false);
        this.func_184212_Q().func_187214_a(AIMING_TICKS, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(IS_MALE, (Object)this.field_70146_Z.nextBoolean());
        this.func_184212_Q().func_187214_a(HAS_SETUP, (Object)false);
        this.setup();
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H()) {
                this.field_70699_by = this.waterNavigator;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigator;
                this.func_204711_a(false);
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        if (this.getTimelordType() == TimelordType.GUARD) {
            this.field_70714_bg.func_75776_a(2, (Goal)new TimelordAttackGoal(this, 1.0, 20, 20.0f));
        }
        if (this.getTimelordType() == TimelordType.COUNCIL) {
            for (Item item : RegenUtil.TIMELORD_CURRENCY.func_230236_b_()) {
                this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), false));
            }
            this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 0.5));
            this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, (double)1.2f, true));
        }
        this.applyEntityAI();
    }

    protected void applyEntityAI() {
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{TimelordEntity.class}));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SkeletonEntity.class, false));
    }

    protected void func_213713_b(MerchantOffer offer) {
        if (offer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    public void setup() {
        if (!this.field_70170_p.func_201670_d()) {
            RegenCap.get((LivingEntity)this).ifPresent(data -> {
                data.addRegens(this.field_70170_p.func_201674_k().nextInt(12));
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74776_a("p_red", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a("p_green", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a("p_blue", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a("s_red", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a("s_green", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a("s_blue", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                data.readStyle(nbt);
                data.setTransitionType(TransitionTypes.getRandomTimelordType());
                this.initSkin((IRegen)data);
                this.genName();
                this.func_180481_a(this.field_70170_p.func_175649_E(this.func_233580_cy_()));
                this.func_184212_Q().func_187227_b(HAS_SETUP, (Object)true);
            });
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    protected void func_70609_aI() {
        EntityType weepingAngel;
        super.func_70609_aI();
        if (ModList.get().isLoaded("weeping_angels") && !this.field_70170_p.field_72995_K && (weepingAngel = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("weeping_angels", "weeping_angel"))) != null && this.field_70170_p.field_73012_v.nextInt(100) < 10) {
            Entity entity = weepingAngel.func_200721_a(this.field_70170_p);
            entity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            this.field_70170_p.func_217376_c(entity);
        }
    }

    public void genName() {
        if (RegenUtil.USERNAMES.length <= 0) {
            RegenUtil.setupNames();
        }
        this.func_200203_b((ITextComponent)new TranslationTextComponent(RegenUtil.USERNAMES[this.field_70146_Z.nextInt(RegenUtil.USERNAMES.length - 1)]));
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new RemoveTimelordSkinMessage(this));
        }
    }

    public void initSkin(IRegen data) {
        this.field_70170_p.func_73046_m().func_222817_e(() -> {
            File file = CommonSkin.chooseRandomSkin(this.field_70170_p.field_73012_v, !this.male(), true);
            if (file != null) {
                data.setSkin(RegenUtil.fileToBytes(file));
            }
            data.setAlexSkin(true);
            data.syncToClients(null);
        });
    }

    public TimelordType getTimelordType() {
        String type = (String)this.func_184212_Q().func_187225_a(TYPE);
        for (TimelordType value : TimelordType.values()) {
            if (!value.name().equals(type)) continue;
            return value;
        }
        return TimelordType.GUARD;
    }

    public void setTimelordType(TimelordType type) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)type.name());
    }

    public void func_70071_h_() {
        if (!((Boolean)this.func_184212_Q().func_187225_a(HAS_SETUP)).booleanValue()) {
            this.setup();
        }
        super.func_70071_h_();
        RegenCap.get((LivingEntity)this).ifPresent(data -> {
            if (!this.field_70170_p.field_72995_K) {
                if (!data.isSkinValidForUse()) {
                    this.initSkin((IRegen)data);
                    data.syncToClients(null);
                }
                if (this.field_70173_aa < 20) {
                    data.syncToClients(null);
                    this.func_213706_dY().removeIf(merchantOffer -> (Boolean)RegenConfig.COMMON.traitsEnabled.get() == false && merchantOffer.func_222200_d().func_77973_b() instanceof ElixirItem || RegenTraitRegistry.stripElixir(merchantOffer.func_222200_d()));
                }
                if (data.regenState().isGraceful() && data.glowing() && data.regenState() == RegenStates.REGENERATING) {
                    if (data.updateTicks() == 100) {
                        this.setMale(this.field_70146_Z.nextBoolean());
                        this.initSkin((IRegen)data);
                    }
                    this.func_94061_f(true);
                    this.func_184224_h(true);
                    return;
                }
                this.func_94061_f(false);
                this.func_184224_h(false);
            }
        });
    }

    public void func_174812_G() {
        if (!this.field_70170_p.field_72995_K) {
            NetworkDispatcher.NETWORK_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new RemoveTimelordSkinMessage(this));
        }
        this.func_70106_y();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("timelord_type", this.getTimelordType().name());
        compound.func_74757_a("is_male", this.male());
        compound.func_74757_a("setup", ((Boolean)this.func_184212_Q().func_187225_a(HAS_SETUP)).booleanValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("timelord_type")) {
            this.setTimelordType(TimelordType.valueOf(compound.func_74779_i("timelord_type")));
        }
        if (compound.func_74764_b("is_male")) {
            this.setMale(compound.func_74767_n("is_male"));
        }
        if (compound.func_74764_b("setup")) {
            this.func_184212_Q().func_187227_b(HAS_SETUP, (Object)compound.func_74767_n("setup"));
        }
    }

    public boolean male() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_MALE);
    }

    public void setMale(boolean male) {
        this.func_184212_Q().func_187227_b(IS_MALE, (Object)male);
    }

    protected void func_213712_ef() {
        if (this.getTimelordType() == TimelordType.COUNCIL) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            if (((Boolean)RegenConfig.COMMON.traitsEnabled.get()).booleanValue()) {
                for (int i = this.field_70146_Z.nextInt(7); i > 0; --i) {
                    AbstractTrait trait = RegenTraitRegistry.getRandomTrait(this.field_70146_Z, false);
                    ItemStack item = new ItemStack((IItemProvider)RItems.ELIXIR.get());
                    Item[] currency = RegenUtil.TIMELORD_CURRENCY.func_230236_b_().toArray(new Item[0]);
                    ElixirItem.setTrait(item, trait);
                    VillagerTrades.ITrade[] trades = new TimelordTrade[]{new TimelordTrade(new ItemStack((IItemProvider)currency[this.field_70146_Z.nextInt(currency.length)], MathHelper.func_76125_a((int)this.field_70146_Z.nextInt(10), (int)6, (int)20)), item, this.field_70146_Z.nextInt(7), 5)};
                    this.func_213717_a(merchantoffers, trades, 5);
                }
            }
            VillagerTrades.ITrade[] tradetrades = new TimelordTrade[]{new TimelordTrade(new ItemStack((IItemProvider)Items.field_151045_i, 3), new ItemStack((IItemProvider)RItems.ZINC.get(), 15), new ItemStack((IItemProvider)RItems.RIFLE.get()), this.field_70146_Z.nextInt(7), 5), new TimelordTrade(new ItemStack((IItemProvider)Items.field_234759_km_, 4), new ItemStack((IItemProvider)RItems.ZINC.get(), 15), new ItemStack((IItemProvider)RItems.PISTOL.get()), this.field_70146_Z.nextInt(7), 5), new TimelordTrade(new ItemStack((IItemProvider)Items.field_151042_j, 4), new ItemStack((IItemProvider)RItems.ZINC.get(), 6), new ItemStack((IItemProvider)RItems.PLASMA_CARTRIDGE.get()), this.field_70146_Z.nextInt(7), 5)};
            this.func_213717_a(merchantoffers, tradetrades, 5);
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.getTimelordType() == TimelordType.GUARD) {
            Item stack = this.field_70146_Z.nextBoolean() ? (Item)RItems.RIFLE.get() : (Item)RItems.PISTOL.get();
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)stack));
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        boolean isPistol = this.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() == RItems.PISTOL.get();
        LaserProjectile laserProjectile = new LaserProjectile((EntityType<? extends ThrowableEntity>)((EntityType)REntities.LASER.get()), (LivingEntity)this, this.field_70170_p);
        laserProjectile.setDamage(isPistol ? 4.0f : 10.0f);
        laserProjectile.setDamageSource(isPistol ? RegenSources.REGEN_DMG_STASER : RegenSources.REGEN_DMG_RIFLE);
        double d0 = target.func_226280_cw_() - (double)1.1f;
        double d1 = target.func_226277_ct_() - this.func_226277_ct_();
        double d2 = d0 - laserProjectile.func_226278_cu_();
        double d3 = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        laserProjectile.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 0.0f);
        this.func_184185_a(isPistol ? (SoundEvent)RSounds.STASER.get() : (SoundEvent)RSounds.RIFLE.get(), 0.3f, 0.4f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)laserProjectile);
    }

    public boolean getAiming() {
        return (Boolean)this.func_184212_Q().func_187225_a(AIMING);
    }

    public void setAiming(boolean isAiming) {
        this.func_184212_Q().func_187227_b(AIMING, (Object)isAiming);
    }

    public float getAimingTicks() {
        return ((Float)this.func_184212_Q().func_187225_a(AIMING_TICKS)).floatValue();
    }

    public void setAimingTicks(float isAiming) {
        this.func_184212_Q().func_187227_b(AIMING_TICKS, (Object)Float.valueOf(isAiming));
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() != RItems.SPAWN_ITEM.get() && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (this.func_213706_dY().isEmpty()) {
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(p_230254_1_);
                if (p_230254_1_ instanceof ServerPlayerEntity) {
                    ServerPlayerEntity playerEntity = (ServerPlayerEntity)p_230254_1_;
                    TriggerManager.TIMELORD_TRADE.trigger(playerEntity);
                }
                this.func_213707_a(p_230254_1_, this.func_145748_c_(), 1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        switch (this.getTimelordType()) {
            case GUARD: {
                ItemStack guardStack = new ItemStack((IItemProvider)RItems.SPAWN_ITEM.get());
                SpawnItem.setType(guardStack, SpawnItem.Timelord.GUARD);
                return guardStack;
            }
            case COUNCIL: {
                ItemStack councilStack = new ItemStack((IItemProvider)RItems.SPAWN_ITEM.get());
                SpawnItem.setType(councilStack, this.male() ? SpawnItem.Timelord.MALE_COUNCIL : SpawnItem.Timelord.FEMALE_COUNCIL);
                return councilStack;
            }
        }
        return null;
    }

    public static class TimelordTrade
    implements VillagerTrades.ITrade {
        private ItemStack coin2;
        private ItemStack coin;
        private ItemStack wares;
        private int xp;
        private int stock;

        public TimelordTrade(ItemStack coin, ItemStack coin2, ItemStack wares, int stock, int xp) {
            this.xp = xp;
            this.stock = stock + 1;
            this.wares = wares;
            this.coin = coin;
            this.coin2 = coin2;
        }

        public TimelordTrade(ItemStack coin, ItemStack wares, int stock, int xp) {
            this(coin, ItemStack.field_190927_a, wares, stock, xp);
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(this.coin, this.coin2, this.wares, this.stock, this.xp, 0.0f);
        }
    }

    public static enum TimelordType {
        COUNCIL("timelord"),
        GUARD("guards");

        private final String name;

        private TimelordType(String guard) {
            this.name = guard;
        }

        public String getName() {
            return this.name;
        }
    }
}

