/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.commands.subcommands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.craig.software.regen.common.commands.arguments.TraitsArgumentType;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.traits.AbstractTrait;
import me.craig.software.regen.common.traits.RegenTraitRegistry;
import me.craig.software.regen.util.RTextHelper;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SetTraitsCommand
implements Command<CommandSource> {
    private static final SetTraitsCommand CMD = new SetTraitsCommand();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return Commands.func_197057_a((String)"set-trait").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"trait", (ArgumentType)TraitsArgumentType.createArgument()).executes((Command)CMD)));
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        CommandSource source = (CommandSource)context.getSource();
        AbstractTrait trait = (AbstractTrait)((Object)context.getArgument("trait", AbstractTrait.class));
        ServerPlayerEntity player = EntityArgument.func_197089_d(context, (String)"player");
        TextComponent playerText = RTextHelper.getPlayerTextObject(source.func_197023_e(), player.func_110124_au());
        TextComponent traitText = RTextHelper.getTraitTextObject(trait);
        if (player == null || trait == null) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("command.regen.set_trait.error", new Object[]{playerText, traitText}));
            return 0;
        }
        RegenCap.get((LivingEntity)player).ifPresent(data -> {
            ResourceLocation oldDna = data.trait().getRegistryName();
            AbstractTrait oldTrait = RegenTraitRegistry.fromID(oldDna);
            oldTrait.remove((IRegen)data);
            data.setTrait(trait);
            trait.apply((IRegen)data);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.regen.set_trait.success", new Object[]{playerText, traitText}), false);
        });
        return 1;
    }
}

