/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.commands.subcommands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.config.RegenConfig;
import me.craig.software.regen.util.RTextHelper;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SetRegensCommand
implements Command<CommandSource> {
    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return Commands.func_197057_a((String)"set-regens").then(Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> SetRegensCommand.setRegenForMultipleEntities((CommandContext<CommandSource>)context, EntityArgument.func_197097_b((CommandContext)context, (String)"entities"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))));
    }

    private static int setRegenForMultipleEntities(CommandContext<CommandSource> context, Collection<? extends Entity> collection, int amount) {
        collection.forEach(target -> SetRegensCommand.setRegenForSingleEntity(context, target, amount));
        return 1;
    }

    private static int setRegenForSingleEntity(CommandContext<CommandSource> context, Entity entity, int amount) {
        TextComponent entityText = RTextHelper.getEntityTextObject(((CommandSource)context.getSource()).func_197023_e(), entity.func_110124_au());
        if (entity instanceof LivingEntity && entity.func_200600_R() != EntityType.field_200789_c && entity != null) {
            if (((Boolean)RegenConfig.COMMON.mobsHaveRegens.get()).booleanValue() || entity instanceof ServerPlayerEntity) {
                LivingEntity ent = (LivingEntity)entity;
                RegenCap.get(ent).ifPresent(cap -> cap.setRegens(amount));
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.regen.set_regen.success", new Object[]{entityText, amount}), false);
                return 1;
            }
            String configOptionKey = "config.regeneration.mobsHaveRegens";
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.regen.set_regen.config_off", new Object[]{entityText, new TranslationTextComponent(configOptionKey).getString(), RegenConfig.COMMON.mobsHaveRegens.get()}));
            return 0;
        }
        ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.regen.set_regen.invalid_entity", new Object[]{amount, entityText}));
        return 0;
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return 0;
    }
}

