/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.common.block;

import me.craig.software.regen.common.item.HandItem;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.common.objects.RSounds;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.common.tiles.JarTile;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class JarBlock
extends DirectionalBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.field_208138_am;

    public JarBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_226896_b_());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)CampfireBlock.field_220103_d, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new JarTile();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(MathHelper.func_76128_c((double)((double)(context.func_195990_h() * 16.0f / 360.0f) + 0.5)) & 0xF));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(rot.func_185833_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(mirrorIn.func_185802_a(((Integer)state.func_177229_b((Property)ROTATION)).intValue(), 16)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ROTATION});
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.func_201670_d()) {
            JarTile jarTile = (JarTile)worldIn.func_175625_s(pos);
            if (handIn == Hand.MAIN_HAND) {
                if (!player.func_225608_bj_()) {
                    if (player.func_184614_ca().func_77973_b() == RItems.HAND.get()) {
                        jarTile.dropHandIfPresent(player);
                        jarTile.setHand(player.func_184614_ca().func_77946_l());
                        jarTile.setUpdateSkin(true);
                        player.func_184614_ca().func_190918_g(1);
                        jarTile.sendUpdates();
                    } else {
                        jarTile.dropHandIfPresent(player);
                        jarTile.sendUpdates();
                    }
                } else if (jarTile.getHand().func_77973_b() == RItems.HAND.get() && jarTile.isValid(JarTile.Action.CREATE)) {
                    RegenCap.get((LivingEntity)player).ifPresent(iRegen -> {
                        if (iRegen.regenState() == RegenStates.ALIVE) {
                            iRegen.addRegens(1);
                            iRegen.setNextTrait(HandItem.getTrait(jarTile.getHand()));
                            iRegen.setNextSkin(HandItem.getSkin(jarTile.getHand()));
                            iRegen.setAlexSkin(HandItem.isAlex(jarTile.getHand()));
                            iRegen.syncToClients(null);
                            iRegen.forceRegeneration();
                            player.func_184185_a((SoundEvent)RSounds.HAND_GLOW.get(), 1.0f, 1.0f);
                            jarTile.setHand(ItemStack.field_190927_a);
                            jarTile.sendUpdates();
                        }
                    });
                }
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!newState.func_203425_a((Block)this) && !worldIn.func_201670_d()) {
            JarTile jarTile = (JarTile)worldIn.func_175625_s(pos);
            jarTile.dropHandIfPresent(null);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!world.func_201670_d()) {
            JarTile jarTile = (JarTile)world.func_175625_s(pos);
            jarTile.dropHandIfPresent(player);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

