/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.client.skin;

import com.google.common.base.MoreObjects;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.network.NetworkDispatcher;
import me.craig.software.regen.network.messages.SkinMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class SkinHandler {
    public static final HashMap<UUID, ResourceLocation> PLAYER_SKINS = new HashMap();

    public static void tick(PlayerEntity playerEntity) {
        RegenCap.get((LivingEntity)playerEntity).ifPresent(iRegen -> {
            NativeImage skinImage;
            byte[] skin = iRegen.skin();
            UUID uuid = playerEntity.func_110124_au();
            boolean validSkin = iRegen.isSkinValidForUse();
            if (!validSkin) {
                SkinHandler.removePlayerSkin(uuid);
            }
            if ((validSkin && !SkinHandler.hasPlayerSkin(uuid) || iRegen.regenState() == RegenStates.REGENERATING && iRegen.updateTicks() >= 140) && (skinImage = SkinHandler.genSkinNative(skin)) != null) {
                boolean isAlex = iRegen.isSkinValidForUse() ? iRegen.currentlyAlex() : SkinHandler.getUnmodifiedSkinType(playerEntity);
                SkinHandler.setPlayerSkinType(playerEntity, isAlex);
                SkinHandler.addPlayerSkin(playerEntity.func_110124_au(), SkinHandler.loadImage(skinImage));
            }
        });
    }

    public static boolean getUnmodifiedSkinType(PlayerEntity player) {
        if (player instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity abstractClientPlayerEntity = (AbstractClientPlayerEntity)player;
            if (abstractClientPlayerEntity.field_175157_a == null) {
                return false;
            }
            abstractClientPlayerEntity.field_175157_a.func_178841_j();
            if (abstractClientPlayerEntity.field_175157_a.func_178851_f() == null) {
                return false;
            }
            if (abstractClientPlayerEntity.field_175157_a.func_178851_f().isEmpty()) {
                return false;
            }
            return abstractClientPlayerEntity.field_175157_a.func_178851_f().contentEquals("slim");
        }
        return false;
    }

    public static void setPlayerSkinType(PlayerEntity player, boolean isAlex) {
        if (player instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity abstractClientPlayerEntity = (AbstractClientPlayerEntity)player;
            NetworkPlayerInfo playerInfo = abstractClientPlayerEntity.field_175157_a;
            if (playerInfo == null) {
                return;
            }
            playerInfo.field_178863_g = isAlex ? "slim" : "default";
        }
    }

    public static void sendResetMessage() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.field_175157_a.func_178841_j();
            boolean isAlex = player.field_175157_a.func_178851_f().equals("slim");
            NetworkDispatcher.NETWORK_CHANNEL.sendToServer((Object)new SkinMessage(new byte[0], isAlex));
        }
    }

    public static ResourceLocation loadImage(NativeImage nativeImage) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        NativeImage converted = DownloadingTexture.func_229163_c_((NativeImage)nativeImage);
        return textureManager.func_110578_a("player_", new DynamicTexture(converted));
    }

    public static NativeImage genSkinNative(byte[] skinArray) {
        try {
            NativeImage skinImage = NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(skinArray));
            return DownloadingTexture.func_229163_c_((NativeImage)skinImage);
        }
        catch (Throwable e) {
            System.err.println("Error while processing skin:");
            e.printStackTrace();
            return null;
        }
    }

    public static void setPlayerSkin(AbstractClientPlayerEntity player, ResourceLocation texture) {
        if (player.func_110306_p().equals((Object)texture)) {
            return;
        }
        NetworkPlayerInfo playerInfo = player.field_175157_a;
        if (playerInfo == null) {
            return;
        }
        Map playerTextures = playerInfo.field_187107_a;
        playerTextures.put(MinecraftProfileTexture.Type.SKIN, texture);
        if (texture == null) {
            playerInfo.field_178864_d = false;
        }
    }

    public static boolean hasPlayerSkin(UUID uuid) {
        return PLAYER_SKINS.containsKey(uuid);
    }

    public static void addPlayerSkin(UUID uuid, ResourceLocation texture) {
        PLAYER_SKINS.put(uuid, texture);
    }

    public static void removePlayerSkin(UUID uuid) {
        PLAYER_SKINS.remove(uuid);
    }

    public static ResourceLocation getSkinToUse(AbstractClientPlayerEntity playerEntity) {
        UUID uuid = playerEntity.func_146103_bH().getId();
        if (PLAYER_SKINS.containsKey(uuid)) {
            return PLAYER_SKINS.get(uuid);
        }
        if (playerEntity.field_175157_a != null) {
            NetworkPlayerInfo info = playerEntity.field_175157_a;
            info.field_178864_d = false;
            info.func_178841_j();
            return (ResourceLocation)MoreObjects.firstNonNull((Object)((ResourceLocation)info.field_187107_a.get(MinecraftProfileTexture.Type.SKIN)), (Object)DefaultPlayerSkin.func_177334_a((UUID)info.field_178867_a.getId()));
        }
        return playerEntity.func_110306_p();
    }
}

