/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.craig.software.regen.client.screen.BlankContainer;
import me.craig.software.regen.client.screen.DescButton;
import me.craig.software.regen.client.screen.PreferencesScreen;
import me.craig.software.regen.client.screen.RCheckbox;
import me.craig.software.regen.client.screen.RErrorScreen;
import me.craig.software.regen.client.skin.CommonSkin;
import me.craig.software.regen.client.skin.SkinHandler;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.network.NetworkDispatcher;
import me.craig.software.regen.network.messages.NextSkinMessage;
import me.craig.software.regen.util.ClientUtil;
import me.craig.software.regen.util.PlayerUtil;
import me.craig.software.regen.util.RegenUtil;
import micdoodle8.mods.galacticraft.api.client.tabs.AbstractTab;
import micdoodle8.mods.galacticraft.api.client.tabs.RegenPrefTab;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class IncarnationScreen
extends ContainerScreen {
    private static final ResourceLocation screenBackground = new ResourceLocation("regen", "textures/gui/customizer.png");
    public static boolean isAlex = true;
    public static ResourceLocation currentTexture = DefaultPlayerSkin.func_177335_a();
    private static PlayerUtil.SkinType currentSkinType;
    private static PlayerUtil.SkinType renderChoice;
    private static List<File> skins;
    private static int position;
    private final ArrayList<DescButton> descButtons = new ArrayList();
    private RCheckbox excludeTrending;
    private TextFieldWidget searchField;
    public boolean isAfterRendering = false;

    public IncarnationScreen() {
        super((Container)new BlankContainer(), Minecraft.func_71410_x().field_71439_g.field_71071_by, (ITextComponent)new StringTextComponent("Next Incarnation"));
        this.field_146999_f = 256;
        this.field_147000_g = 173;
    }

    public static void updateModels() {
        if (!skins.isEmpty()) {
            currentTexture = CommonSkin.fileTotexture(skins.get(position));
            System.out.println(skins.get(position).toPath() + " || " + CommonSkin.SKIN_DIRECTORY_ALEX);
            isAlex = skins.get(position).toString().contains("\\skins\\alex");
            renderChoice = isAlex ? PlayerUtil.SkinType.ALEX : PlayerUtil.SkinType.STEVE;
        }
    }

    public boolean func_231177_au__() {
        return true;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        TabRegistry.updateTabValues(this.field_147003_i + 2, this.field_147009_r, RegenPrefTab.class);
        for (AbstractTab button2 : TabRegistry.getTabList()) {
            this.func_230481_d_((IGuiEventListener)button2);
        }
        int buttonOffset = 35;
        int cx = (this.field_230708_k_ - this.field_146999_f) / 2;
        int cy = (this.field_230709_l_ - this.field_147000_g) / 2;
        int btnW = 55;
        int btnH = 18;
        position = 0;
        skins = CommonSkin.listAllSkins(PlayerUtil.SkinType.EITHER);
        if (skins.isEmpty()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new RErrorScreen((ITextComponent)new TranslationTextComponent("No Skins for " + new TranslationTextComponent("regeneration.skin_type." + currentSkinType.name().toLowerCase()).getString()), (ITextComponent)new TranslationTextComponent("Please place skins in the local Directory")));
        }
        this.searchField = new TextFieldWidget(this.field_230712_o_, cx + 15, cy + 145, this.field_146999_f - 70, 20, this.searchField, (ITextComponent)new TranslationTextComponent("skins.search"));
        this.searchField.func_212954_a(p_214329_1_ -> {
            position = 0;
            skins.removeIf(file -> !file.getName().toLowerCase().contains(this.searchField.func_146179_b().toLowerCase()));
            if (skins.isEmpty() || this.searchField.func_146179_b().isEmpty()) {
                skins = CommonSkin.listAllSkins(currentSkinType);
            }
            this.stripTrending();
            Collections.sort(skins);
            IncarnationScreen.updateModels();
        });
        this.field_230705_e_.add(this.searchField);
        this.func_212928_a((IGuiEventListener)this.searchField);
        DescButton btnPrevious = new DescButton(cx + 140, cy + 60, 20, 20, (ITextComponent)new TranslationTextComponent("regen.gui.previous"), button -> {
            if (this.searchField.func_146179_b().isEmpty()) {
                skins = CommonSkin.listAllSkins(currentSkinType);
            }
            this.stripTrending();
            position = position >= skins.size() - 1 ? 0 : ++position;
            IncarnationScreen.updateModels();
        }).setDescription(new String[]{"button.tooltip.previous_skin"});
        DescButton btnNext = new DescButton(cx + 215, cy + 60, 20, 20, (ITextComponent)new TranslationTextComponent("regen.gui.next"), button -> {
            if (this.searchField.func_146179_b().isEmpty()) {
                skins = CommonSkin.listAllSkins(currentSkinType);
            }
            this.stripTrending();
            position = position > 0 ? --position : skins.size() - 1;
            currentTexture = CommonSkin.fileTotexture(skins.get(position));
            IncarnationScreen.updateModels();
        }).setDescription(new String[]{"button.tooltip.next_skin"});
        DescButton btnBack = new DescButton(cx + 10, cy + 115 - buttonOffset, 55, 20, (ITextComponent)new TranslationTextComponent("regen.gui.back"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new PreferencesScreen()));
        DescButton btnOpenFolder = new DescButton(cx + 90 - 20, cy + 115 - buttonOffset, 55, 20, (ITextComponent)new TranslationTextComponent("regen.gui.open_folder"), button -> Util.func_110647_a().func_195641_a(CommonSkin.SKIN_DIRECTORY)).setDescription(new String[]{"button.tooltip.open_folder"});
        DescButton btnSave = new DescButton(cx + 90 - 20, cy + 90 - buttonOffset, 55, 20, (ITextComponent)new TranslationTextComponent("regen.gui.save"), button -> {
            IncarnationScreen.updateModels();
            NetworkDispatcher.NETWORK_CHANNEL.sendToServer((Object)new NextSkinMessage(RegenUtil.fileToBytes(skins.get(position)), isAlex));
        }).setDescription(new String[]{"button.tooltip.save_skin"});
        DescButton btnResetSkin = new DescButton(cx + 10, cy + 90 - buttonOffset, 55, 20, (ITextComponent)new TranslationTextComponent("regen.gui.reset_skin"), button -> SkinHandler.sendResetMessage()).setDescription(new String[]{"button.tooltip.reset_mojang"});
        this.excludeTrending = new RCheckbox(cx + 10, cy + 25, 150, 20, (ITextComponent)new TranslationTextComponent("Trending?"), true, checkboxButton -> {
            if (checkboxButton instanceof CheckboxButton) {
                CheckboxButton check = (CheckboxButton)checkboxButton;
                position = 0;
                this.searchField.func_146180_a("");
                if (!check.func_212942_a()) {
                    skins.removeIf(file -> file.getAbsoluteFile().toPath().toString().contains("mineskin"));
                } else {
                    skins = CommonSkin.listAllSkins(currentSkinType);
                }
                IncarnationScreen.updateModels();
            }
        });
        this.func_230480_a_((Widget)this.excludeTrending);
        this.func_230480_a_((Widget)btnNext);
        this.func_230480_a_((Widget)btnPrevious);
        this.func_230480_a_((Widget)btnOpenFolder);
        this.func_230480_a_((Widget)btnBack);
        this.func_230480_a_((Widget)btnSave);
        this.func_230480_a_((Widget)btnResetSkin);
        for (IGuiEventListener widget : this.field_230710_m_) {
            if (!(widget instanceof DescButton)) continue;
            this.descButtons.add((DescButton)widget);
        }
        RegenCap.get((LivingEntity)this.field_230706_i_.field_71439_g).ifPresent(data -> {
            currentSkinType = data.preferredModel();
        });
        RegenCap.get((LivingEntity)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
            currentSkinType = data.preferredModel();
        });
        IncarnationScreen.updateModels();
        this.excludeTrending.field_230693_o_ = true;
    }

    private void stripTrending() {
        if (!this.excludeTrending.func_212942_a()) {
            skins.removeIf(file -> file.getAbsoluteFile().toPath().toString().contains("mineskin"));
        }
    }

    protected void func_230450_a_(@NotNull MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(screenBackground);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.isAfterRendering = false;
        this.renderSkinToGui(matrixStack, x, y);
        this.isAfterRendering = true;
        IncarnationScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)new TranslationTextComponent("regen.gui.current_skin").getString(), (int)(this.field_230708_k_ / 2 + 60), (int)(this.field_230709_l_ / 2 + 30), (int)Color.WHITE.getRGB());
        if (!skins.isEmpty() && position < skins.size()) {
            matrixStack.func_227860_a_();
            String name = skins.get(position).getName().replaceAll(".png", "");
            this.renderWidthScaledText(name, matrixStack, this.field_230712_o_, this.field_230708_k_ / 2 + 60, this.field_230709_l_ / 2 + 40, Color.WHITE.getRGB(), 100);
            matrixStack.func_227865_b_();
        }
        IncarnationScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)new TranslationTextComponent("Search"), (int)(this.field_230708_k_ / 2 - 95), (int)(this.field_230709_l_ / 2 + 45), (int)Color.WHITE.getRGB());
    }

    private void renderSkinToGui(MatrixStack matrixStack, int x, int y) {
        matrixStack.func_227860_a_();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        boolean backupSkinType = ClientUtil.isAlex((Entity)player);
        SkinHandler.setPlayerSkinType((PlayerEntity)Minecraft.func_71410_x().field_71439_g, renderChoice == PlayerUtil.SkinType.ALEX);
        InventoryScreen.func_228187_a_((int)(this.field_230708_k_ / 2 + 60), (int)(this.field_230709_l_ / 2 + 20), (int)45, (float)((float)(this.field_147003_i + 170) - (float)x), (float)((float)(this.field_147009_r + 75 - 25) - (float)y), (LivingEntity)Minecraft.func_71410_x().field_71439_g);
        SkinHandler.setPlayerSkinType((PlayerEntity)Minecraft.func_71410_x().field_71439_g, backupSkinType);
        matrixStack.func_227865_b_();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        this.searchField.func_231046_a_(keyCode, scanCode, modifiers);
        if (keyCode == 262) {
            if (position >= skins.size() - 1) {
                position = 0;
            } else {
                Minecraft.func_71410_x().func_110434_K().func_147645_c(currentTexture);
                currentTexture = CommonSkin.fileTotexture(skins.get(++position));
                IncarnationScreen.updateModels();
            }
        }
        if (keyCode == 263) {
            position = position > 0 ? --position : skins.size() - 1;
            currentTexture = CommonSkin.fileTotexture(skins.get(position));
            IncarnationScreen.updateModels();
        }
        if (keyCode == 256 && this.func_231178_ax__()) {
            this.func_231175_as__();
            return true;
        }
        return false;
    }

    protected void func_230451_b_(@NotNull MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_.getString(), (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        for (DescButton descButton : this.descButtons) {
            if (!descButton.func_230449_g_() || descButton.getDescription() == null) continue;
            this.renderToolTip(matrixStack, descButton.getDescription(), mouseX, mouseY, Minecraft.func_71410_x().field_71466_p);
        }
    }

    public void renderWidthScaledText(String text, MatrixStack matrix, FontRenderer font, float x, float y, int color, int width) {
        matrix.func_227860_a_();
        int textWidth = font.func_78256_a(text);
        float scale = (float)width / (float)textWidth;
        scale = MathHelper.func_76131_a((float)scale, (float)0.0f, (float)1.0f);
        matrix.func_227861_a_((double)x, (double)y, 0.0);
        matrix.func_227862_a_(scale, scale, scale);
        IncarnationScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)text, (int)0, (int)0, (int)Color.WHITE.getRGB());
        matrix.func_227865_b_();
    }

    static {
        renderChoice = currentSkinType = ((IRegen)RegenCap.get((LivingEntity)Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g)).orElse(null)).preferredModel();
        skins = null;
        position = 0;
    }
}

