/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import me.craig.software.regen.client.screen.RCheckbox;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;

public class ColorWidget
extends Widget {
    protected final RCheckbox.IInteraction<ColorWidget> onPress;
    private final int radius;
    private final int textHeight;
    private int color;
    private TextFieldWidget text = null;

    public ColorWidget(FontRenderer font, int x, int y, int width, int textHeight, ITextComponent title, int defaultColor, RCheckbox.IInteraction<ColorWidget> iInteraction) {
        super(x, y, width, width, title);
        this.radius = width / 2;
        this.color = defaultColor;
        this.text = new TextFieldWidget(font, x, y + width + 10, width - textHeight - 5, textHeight, this.text, title);
        this.text.func_146184_c(true);
        this.textHeight = textHeight;
        this.onPress = iInteraction;
        this.text.func_212954_a(s -> {
            try {
                Color color = Color.decode(s);
                this.setColor(color.getRGB());
                this.updateColor();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.updateColor();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            for (int x = -this.radius; x < this.radius; ++x) {
                for (int y = -this.radius; y < this.radius; ++y) {
                    double distance = Math.sqrt(x * x + y * y);
                    if (distance > (double)this.radius) continue;
                    double angle = Math.atan2(y, x);
                    double degrees = Math.toDegrees(angle);
                    float hue = (float)(degrees < 0.0 ? 360.0 + degrees : degrees);
                    float saturation = (float)(distance / (double)this.radius);
                    ColorWidget.func_238467_a_((MatrixStack)matrixStack, (int)(x + this.radius + this.field_230690_l_), (int)(y + this.radius + this.field_230691_m_), (int)(x + this.radius + 1 + this.field_230690_l_), (int)(y + this.radius + 1 + this.field_230691_m_), (int)this.hsv2rgb(hue, saturation, 1.0f));
                }
            }
        }
        this.text.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ColorWidget.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + this.field_230688_j_ - this.textHeight - 1), (int)(this.field_230691_m_ + this.field_230688_j_ + 9), (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230688_j_ + 10 + this.textHeight + 1), (int)-6381922);
        ColorWidget.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + this.field_230688_j_ - this.textHeight), (int)(this.field_230691_m_ + this.field_230688_j_ + 10), (int)(this.field_230690_l_ + this.field_230688_j_ - 1), (int)(this.field_230691_m_ + this.field_230688_j_ + 10 + this.textHeight), (int)this.color);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        double distance = Math.sqrt(Math.pow(mouseX - (double)this.field_230690_l_ - (double)this.radius, 2.0) + Math.pow(mouseY - (double)this.field_230691_m_ - (double)this.radius, 2.0));
        if (distance <= (double)this.radius) {
            double angle = Math.atan2(mouseY - (double)this.field_230691_m_ - (double)this.radius, mouseX - (double)this.field_230690_l_ - (double)this.radius);
            double degrees = Math.toDegrees(angle);
            float hue = (float)(degrees < 0.0 ? 360.0 + degrees : degrees);
            float saturation = (float)(distance / (double)this.radius);
            this.color = this.hsv2rgb(hue, saturation, 1.0f);
            this.updateColor();
        }
        this.onPress.onPress(this);
    }

    private void updateColor() {
        this.text.func_146180_a(String.format("#%s", Integer.toHexString(this.color)).toUpperCase());
    }

    public int hsv2rgb(float hue, float saturation, float value) {
        float chroma = value * saturation;
        float hue1 = hue / 60.0f;
        float x = chroma * (1.0f - Math.abs(hue1 % 2.0f - 1.0f));
        float r1 = 0.0f;
        float g1 = 0.0f;
        float b1 = 0.0f;
        if (hue1 >= 0.0f && hue1 <= 1.0f) {
            r1 = chroma;
            g1 = x;
            b1 = 0.0f;
        } else if (hue1 >= 1.0f && hue1 <= 2.0f) {
            r1 = x;
            g1 = chroma;
            b1 = 0.0f;
        } else if (hue1 >= 2.0f && hue1 <= 3.0f) {
            r1 = 0.0f;
            g1 = chroma;
            b1 = x;
        } else if (hue1 >= 3.0f && hue1 <= 4.0f) {
            r1 = 0.0f;
            g1 = x;
            b1 = chroma;
        } else if (hue1 >= 4.0f && hue1 <= 5.0f) {
            r1 = x;
            g1 = 0.0f;
            b1 = chroma;
        } else if (hue1 >= 5.0f && hue1 <= 6.0f) {
            r1 = chroma;
            g1 = 0.0f;
            b1 = x;
        }
        float m = value - chroma;
        float r = r1 + m;
        float g = g1 + m;
        float b = b1 + m;
        return 0xFF000000 | ((int)(255.0f * r) & 0xFF) << 16 | ((int)(255.0f * g) & 0xFF) << 8 | (int)(255.0f * b) & 0xFF;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.updateColor();
    }

    public void tick() {
        this.text.func_146178_a();
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        this.text.func_231046_a_(keyCode, scanCode, modifiers);
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }
}

