/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import me.craig.software.regen.client.screen.BlankContainer;
import me.craig.software.regen.client.screen.ColorWidget;
import me.craig.software.regen.client.screen.PreferencesScreen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.transitions.TransitionType;
import me.craig.software.regen.network.NetworkDispatcher;
import me.craig.software.regen.network.messages.ColorChangeMessage;
import micdoodle8.mods.galacticraft.api.client.tabs.AbstractTab;
import micdoodle8.mods.galacticraft.api.client.tabs.RegenPrefTab;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ColorScreen
extends ContainerScreen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("regen", "textures/gui/customizer.png");
    private Vector3d initialPrimary;
    private Vector3d initialSecondary;
    private ColorWidget colorChooserPrimary;
    private ColorWidget colorChooserSecondary;

    public ColorScreen() {
        super((Container)new BlankContainer(), Minecraft.func_71410_x().field_71439_g.field_71071_by, (ITextComponent)new TranslationTextComponent("regen.gui.color_gui"));
        this.field_146999_f = 256;
        this.field_147000_g = 173;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        TabRegistry.updateTabValues(this.field_147003_i + 2, this.field_147009_r, RegenPrefTab.class);
        for (AbstractTab button2 : TabRegistry.getTabList()) {
            this.func_230480_a_((Widget)button2);
        }
        int cx = (this.field_230708_k_ - this.field_146999_f) / 2;
        int cy = (this.field_230709_l_ - this.field_147000_g) / 2;
        RegenCap.get((LivingEntity)this.getMinecraft().field_71439_g).ifPresent(data -> {
            this.initialPrimary = data.getPrimaryColors();
            this.initialSecondary = data.getSecondaryColors();
        });
        int btnW = 60;
        int btnH = 18;
        this.func_230480_a_((Widget)new Button(cx + 100, cy + 145, 60, 20, (ITextComponent)new TranslationTextComponent("regen.gui.undo"), button -> {
            Color primaryColour = new Color((float)this.initialPrimary.field_72450_a, (float)this.initialPrimary.field_72448_b, (float)this.initialPrimary.field_72449_c);
            Color secondaryColour = new Color((float)this.initialSecondary.field_72450_a, (float)this.initialSecondary.field_72448_b, (float)this.initialSecondary.field_72449_c);
            this.colorChooserPrimary.setColor(primaryColour.getRGB());
            this.colorChooserSecondary.setColor(secondaryColour.getRGB());
            this.updateScreenAndServer();
        }));
        this.func_230480_a_((Widget)new Button(cx + 25, cy + 145, 60, 20, (ITextComponent)new TranslationTextComponent("regen.gui.back"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new PreferencesScreen())));
        this.func_230480_a_((Widget)new Button(cx + 180, cy + 145, 60, 20, (ITextComponent)new TranslationTextComponent("regen.gui.default"), button -> RegenCap.get((LivingEntity)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
            TransitionType regenType = data.transitionType();
            Vector3d primColor = regenType.getDefaultPrimaryColor();
            Vector3d secColor = regenType.getDefaultSecondaryColor();
            Color primaryColour = new Color((float)primColor.field_72450_a, (float)primColor.field_72448_b, (float)primColor.field_72449_c);
            Color secondaryColour = new Color((float)secColor.field_72450_a, (float)secColor.field_72448_b, (float)secColor.field_72449_c);
            this.colorChooserPrimary.setColor(primaryColour.getRGB());
            this.colorChooserSecondary.setColor(secondaryColour.getRGB());
            this.updateScreenAndServer();
        })));
        this.colorChooserPrimary = new ColorWidget(this.field_230712_o_, cx + 20, cy + 35, 70, 20, (ITextComponent)new StringTextComponent("Regen"), new Color((float)this.initialPrimary.field_72450_a, (float)this.initialPrimary.field_72448_b, (float)this.initialPrimary.field_72449_c).getRGB(), p_onPress_1_ -> this.updateScreenAndServer());
        this.colorChooserSecondary = new ColorWidget(this.field_230712_o_, cx + 150, cy + 35, 70, 20, (ITextComponent)new StringTextComponent("Regen"), new Color((float)this.initialSecondary.field_72450_a, (float)this.initialSecondary.field_72448_b, (float)this.initialSecondary.field_72449_c).getRGB(), p_onPress_1_ -> this.updateScreenAndServer());
        this.field_230705_e_.add(this.colorChooserPrimary);
        this.field_230705_e_.add(this.colorChooserSecondary);
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
        this.field_230712_o_.func_238421_b_(p_230451_1_, this.field_230704_d_.getString(), (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }

    public void updateScreenAndServer() {
        CompoundNBT nbt = new CompoundNBT();
        Color primary = new Color(this.colorChooserPrimary.getColor());
        Color secondary = new Color(this.colorChooserSecondary.getColor());
        nbt.func_74776_a("p_red", (float)primary.getRed() / 255.0f);
        nbt.func_74776_a("p_green", (float)primary.getGreen() / 255.0f);
        nbt.func_74776_a("p_blue", (float)primary.getBlue() / 255.0f);
        nbt.func_74776_a("s_red", (float)secondary.getRed() / 255.0f);
        nbt.func_74776_a("s_green", (float)secondary.getGreen() / 255.0f);
        nbt.func_74776_a("s_blue", (float)secondary.getBlue() / 255.0f);
        NetworkDispatcher.NETWORK_CHANNEL.sendToServer((Object)new ColorChangeMessage(nbt));
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        if (this.field_230706_i_ != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
            int i = (this.field_230708_k_ - this.field_146999_f) / 2;
            int j = (this.field_230709_l_ - this.field_147000_g) / 2;
            this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        int cx = (this.field_230708_k_ - this.field_146999_f) / 2;
        int cy = (this.field_230709_l_ - this.field_147000_g) / 2;
        RegenCap.get((LivingEntity)this.getMinecraft().field_71439_g).ifPresent(cap -> {
            String str = new TranslationTextComponent("regen.gui.primary").getString();
            int length = this.getMinecraft().field_71466_p.func_78256_a(str);
            this.field_230712_o_.func_238421_b_(matrixStack, new StringTextComponent(str).getString(), (float)cx + 55.0f - (float)(length / 2), (float)(cy + 19), 0x404040);
            str = new TranslationTextComponent("regen.gui.secondary").getString();
            length = this.field_230712_o_.func_78256_a(str);
            this.field_230712_o_.func_238421_b_(matrixStack, new StringTextComponent(str).getString(), (float)(cx + 185 - length / 2), (float)(cy + 19), 0x404040);
        });
        this.colorChooserPrimary.func_230430_a_(matrixStack, x, y, partialTicks);
        this.colorChooserSecondary.func_230430_a_(matrixStack, x, y, partialTicks);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.colorChooserPrimary.tick();
        this.colorChooserSecondary.tick();
    }
}

