/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.client.rendering.transitions;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.craig.software.regen.client.rendering.transitions.FieryTransitionRenderer;
import me.craig.software.regen.client.rendering.transitions.TransitionRenderer;
import me.craig.software.regen.client.rendering.types.RenderTypes;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.common.regen.transitions.TransitionTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;

public class SparkleTransitionRenderer
implements TransitionRenderer {
    public static SparkleTransitionRenderer INSTANCE = new SparkleTransitionRenderer();

    @Override
    public void onPlayerRenderPre(RenderPlayerEvent.Pre pre) {
        PlayerEntity player = pre.getPlayer();
        RegenCap.get((LivingEntity)player).ifPresent(iRegen -> {
            if (iRegen.regenState() == RegenStates.REGENERATING) {
                MatrixStack maxtrix = pre.getMatrixStack();
                player.field_70760_ar = 0.0f;
                player.field_70761_aq = 0.0f;
                maxtrix.func_227861_a_(0.0, 0.1, 0.0);
                maxtrix.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
            }
        });
    }

    @Override
    public void onPlayerRenderPost(RenderPlayerEvent.Post post) {
        PlayerEntity player = post.getPlayer();
        RegenCap.get((LivingEntity)player).ifPresent(iRegen -> {
            if (iRegen.regenState() == RegenStates.REGENERATING) {
                player.field_70761_aq = player.field_70760_ar = player.field_70177_z;
            }
        });
    }

    @Override
    public void firstPersonHand(RenderHandEvent renderHandEvent) {
    }

    @Override
    public void thirdPersonHand(HandSide side, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Entity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Override
    public void layer(BipedModel<?> bipedModel, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Entity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        RegenCap.get((LivingEntity)entitylivingbaseIn).ifPresent(iRegen -> {
            if (iRegen.regenState() == RegenStates.REGENERATING) {
                float opacity = MathHelper.func_76131_a((float)(MathHelper.func_76126_a((float)(((float)entitylivingbaseIn.field_70173_aa + Minecraft.func_71410_x().func_184121_ak()) / 5.0f)) * 0.1f + 0.1f), (float)0.11f, (float)1.0f);
                FieryTransitionRenderer.renderOverlay(matrixStackIn, bufferIn.getBuffer(RenderTypes.func_228630_a_((int)1)), packedLightIn, bipedModel, (LivingEntity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, opacity, iRegen.getPrimaryColors());
                FieryTransitionRenderer.renderOverlay(matrixStackIn, bufferIn.getBuffer(RenderTypes.func_228630_a_((int)2)), packedLightIn, bipedModel, (LivingEntity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, opacity, iRegen.getPrimaryColors());
            }
        });
    }

    public void animate(BipedModel bipedModel, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        RegenCap.get(livingEntity).ifPresent(data -> {
            if (data.regenState() == RegenStates.REGENERATING && data.transitionType() == TransitionTypes.SPARKLE.get()) {
                bipedModel.field_78116_c.field_78795_f = (float)Math.toRadians(-20.0);
                bipedModel.field_78116_c.field_78796_g = (float)Math.toRadians(0.0);
                bipedModel.field_78116_c.field_78808_h = (float)Math.toRadians(0.0);
                bipedModel.field_178722_k.field_78808_h = (float)(-Math.toRadians(5.0));
                bipedModel.field_178721_j.field_78808_h = (float)Math.toRadians(5.0);
                bipedModel.field_178724_i.field_78808_h = (float)(-Math.toRadians(5.0));
                bipedModel.field_178723_h.field_78808_h = (float)Math.toRadians(5.0);
            }
        });
    }
}

