/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.client.rendering.transitions;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.craig.software.regen.client.animation.AnimationHandler;
import me.craig.software.regen.client.rendering.layers.RenderRegenLayer;
import me.craig.software.regen.client.rendering.transitions.TransitionRenderer;
import me.craig.software.regen.client.rendering.types.RenderTypes;
import me.craig.software.regen.common.entities.TimelordEntity;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.state.RegenStates;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;

public class FieryTransitionRenderer
implements TransitionRenderer {
    public static final FieryTransitionRenderer INSTANCE = new FieryTransitionRenderer();

    public static void renderOverlay(MatrixStack matrixStack, IVertexBuilder buffer, int packedlight, BipedModel bipedModel, LivingEntity entityPlayer, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float opacity, Vector3d color) {
        FieryTransitionRenderer.renderOverlay(matrixStack, buffer, packedlight, bipedModel, entityPlayer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, opacity, color, null);
    }

    public static void renderOverlay(MatrixStack matrixStack, IVertexBuilder buffer, int packedlight, BipedModel bipedModel, LivingEntity entityPlayer, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float opacity, Vector3d color, AnimationHandler.Animation animation) {
        RegenCap.get(entityPlayer).ifPresent(data -> {
            matrixStack.func_227860_a_();
            if (animation == null) {
                bipedModel.func_225597_a_(entityPlayer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            } else {
                animation.animate(bipedModel, entityPlayer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
            bipedModel.func_225598_a_(matrixStack, buffer, packedlight, OverlayTexture.field_229196_a_, (float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, opacity);
            matrixStack.func_227865_b_();
        });
    }

    @Override
    public void onPlayerRenderPre(RenderPlayerEvent.Pre pre) {
    }

    @Override
    public void onPlayerRenderPost(RenderPlayerEvent.Post post) {
    }

    @Override
    public void firstPersonHand(RenderHandEvent renderHandEvent) {
    }

    @Override
    public void thirdPersonHand(HandSide side, MatrixStack matrix, IRenderTypeBuffer bufferIn, int packedLightIn, Entity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entitylivingbaseIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entitylivingbaseIn;
            RegenCap.get(livingEntity).ifPresent(iRegen -> {
                if (iRegen.regenState() == RegenStates.REGENERATING) {
                    double x = iRegen.updateTicks();
                    double p = 109.89010989010987;
                    double r = 0.09890109890109888;
                    double f = p * Math.pow(x, 2.0) - r;
                    float cf = MathHelper.func_76131_a((float)((float)f), (float)0.0f, (float)1.0f);
                    float primaryScale = cf * 4.0f;
                    float secondaryScale = cf * 6.4f;
                    Vector3d primaryColors = iRegen.getPrimaryColors();
                    Vector3d secondaryColors = iRegen.getSecondaryColors();
                    RenderRegenLayer.renderColorCone(matrix, bufferIn.getBuffer(RenderTypes.REGEN_FLAMES), packedLightIn, livingEntity, primaryScale, primaryScale, primaryColors);
                    RenderRegenLayer.renderColorCone(matrix, bufferIn.getBuffer(RenderTypes.REGEN_FLAMES), packedLightIn, livingEntity, secondaryScale, secondaryScale, secondaryColors);
                }
            });
        }
    }

    @Override
    public void layer(BipedModel<?> bipedModel, MatrixStack matrix, IRenderTypeBuffer bufferIn, int packedLightIn, Entity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        RegenCap.get((LivingEntity)entitylivingbaseIn).ifPresent(iRegen -> {
            if (iRegen.regenState() == RegenStates.REGENERATING) {
                matrix.func_227860_a_();
                bipedModel.field_78116_c.func_228307_a_(matrix);
                matrix.func_227861_a_(0.0, (double)0.09f, (double)0.2f);
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(180.0f));
                double x = iRegen.updateTicks();
                double p = 109.89010989010987;
                double r = 0.09890109890109888;
                double f = p * Math.pow(x, 2.0) - r;
                float cf = MathHelper.func_76131_a((float)((float)f), (float)0.0f, (float)1.0f);
                float primaryScale = cf * 4.0f;
                float secondaryScale = cf * 6.4f;
                CompoundNBT colorTag = iRegen.getOrWriteStyle();
                Vector3d primaryColors = new Vector3d((double)colorTag.func_74760_g("p_red"), (double)colorTag.func_74760_g("p_green"), (double)colorTag.func_74760_g("p_blue"));
                Vector3d secondaryColors = new Vector3d((double)colorTag.func_74760_g("s_red"), (double)colorTag.func_74760_g("s_green"), (double)colorTag.func_74760_g("s_blue"));
                RenderRegenLayer.renderColorCone(matrix, bufferIn.getBuffer(RenderTypes.REGEN_FLAMES), packedLightIn, iRegen.getLiving(), primaryScale, primaryScale, primaryColors);
                RenderRegenLayer.renderColorCone(matrix, bufferIn.getBuffer(RenderTypes.REGEN_FLAMES), packedLightIn, iRegen.getLiving(), secondaryScale, secondaryScale, secondaryColors);
                matrix.func_227865_b_();
            }
            if (((LivingEntity)entitylivingbaseIn).field_70737_aN > 0 && iRegen.regenState() == RegenStates.POST || iRegen.regenState() == RegenStates.REGENERATING) {
                if (entitylivingbaseIn instanceof TimelordEntity) {
                    return;
                }
                float opacity = MathHelper.func_76131_a((float)(MathHelper.func_76126_a((float)(((float)entitylivingbaseIn.field_70173_aa + Minecraft.func_71410_x().func_184121_ak()) / 5.0f)) * 0.1f + 0.1f), (float)0.11f, (float)1.0f);
                FieryTransitionRenderer.renderOverlay(matrix, bufferIn.getBuffer(RenderTypes.func_228630_a_((int)1)), packedLightIn, bipedModel, (LivingEntity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, opacity, iRegen.getPrimaryColors());
                FieryTransitionRenderer.renderOverlay(matrix, bufferIn.getBuffer(RenderTypes.func_228630_a_((int)2)), packedLightIn, bipedModel, (LivingEntity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, opacity, iRegen.getPrimaryColors());
            }
        });
    }

    public void animate(BipedModel bipedModel, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        RegenCap.get(livingEntity).ifPresent(iRegen -> {
            if (iRegen.regenState() == RegenStates.REGENERATING) {
                double armShake = livingEntity.func_70681_au().nextDouble();
                float armRotY = (float)iRegen.updateTicks() * 1.5f;
                float armRotZ = (float)iRegen.updateTicks() * 1.5f;
                float headRot = (float)iRegen.updateTicks() * 1.5f;
                if (armRotY > 95.0f) {
                    armRotY = 95.0f;
                }
                if (armRotZ > 95.0f) {
                    armRotZ = 95.0f;
                }
                if (headRot > 45.0f) {
                    headRot = 45.0f;
                }
                bipedModel.field_178724_i.field_78796_g = 0.0f;
                bipedModel.field_178723_h.field_78796_g = 0.0f;
                bipedModel.field_178724_i.field_78795_f = 0.0f;
                bipedModel.field_178723_h.field_78795_f = 0.0f;
                bipedModel.field_178724_i.field_78808_h = (float)(-Math.toRadians((double)armRotZ + armShake));
                bipedModel.field_178723_h.field_78808_h = (float)Math.toRadians((double)armRotZ + armShake);
                bipedModel.field_178724_i.field_78796_g = (float)(-Math.toRadians(armRotY));
                bipedModel.field_178723_h.field_78796_g = (float)Math.toRadians(armRotY);
                bipedModel.field_78115_e.field_78795_f = 0.0f;
                bipedModel.field_78115_e.field_78796_g = 0.0f;
                bipedModel.field_78115_e.field_78808_h = 0.0f;
                bipedModel.field_178722_k.field_78796_g = 0.0f;
                bipedModel.field_178721_j.field_78796_g = 0.0f;
                bipedModel.field_178722_k.field_78795_f = 0.0f;
                bipedModel.field_178721_j.field_78795_f = 0.0f;
                bipedModel.field_178722_k.field_78808_h = (float)(-Math.toRadians(5.0));
                bipedModel.field_178721_j.field_78808_h = (float)Math.toRadians(5.0);
                bipedModel.field_78116_c.field_78795_f = (float)Math.toRadians(-headRot);
                bipedModel.field_78116_c.field_78796_g = (float)Math.toRadians(0.0);
                bipedModel.field_78116_c.field_78808_h = (float)Math.toRadians(0.0);
            }
        });
    }
}

