/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.client.rendering.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import me.craig.software.regen.client.rendering.layers.HandLayer;
import me.craig.software.regen.client.rendering.layers.RenderRegenLayer;
import me.craig.software.regen.client.rendering.layers.TimelordHeadLayer;
import me.craig.software.regen.client.rendering.model.TimelordGuardModel;
import me.craig.software.regen.client.rendering.model.TimelordModel;
import me.craig.software.regen.common.entities.TimelordEntity;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.config.RegenConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class TimelordRenderer
extends LivingRenderer<TimelordEntity, BipedModel<TimelordEntity>> {
    public static EntityModel<TimelordEntity> mainModel = new TimelordModel();
    public static EntityModel<TimelordEntity> councilModel = new TimelordModel();
    public static EntityModel<TimelordEntity> guardModel = new TimelordGuardModel();
    public static HashMap<UUID, ResourceLocation> TIMELORDS = new HashMap();

    public TimelordRenderer(EntityRendererManager entityRendererManager) {
        super(entityRendererManager, (EntityModel)new BipedModel(1.0f), 0.1f);
        this.func_177094_a(new RenderRegenLayer((IEntityRenderer)this));
        this.func_177094_a(new HandLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new ArrowLayer((LivingRenderer)this));
        this.func_177094_a(new TimelordHeadLayer((IEntityRenderer<TimelordEntity, BipedModel<TimelordEntity>>)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
    }

    public static ResourceLocation getTimelordFace(TimelordEntity timelordEntity) {
        IRegen data = (IRegen)RegenCap.get((LivingEntity)timelordEntity).orElseGet(null);
        if (data.updateTicks() > 100 && data.updateTicks() < 105) {
            TIMELORDS.remove(timelordEntity.func_110124_au());
        }
        if (TIMELORDS.containsKey(timelordEntity.func_110124_au())) {
            return TIMELORDS.get(timelordEntity.func_110124_au());
        }
        NativeImage nativeImage = null;
        try {
            if (data.isSkinValidForUse()) {
                nativeImage = NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(data.skin()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (nativeImage == null) {
            return DefaultPlayerSkin.func_177335_a();
        }
        ResourceLocation location = Minecraft.func_71410_x().func_110434_K().func_110578_a("timelord_", new DynamicTexture(nativeImage));
        TIMELORDS.put(timelordEntity.func_110124_au(), location);
        return location;
    }

    public void render(TimelordEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        switch (entityIn.getTimelordType()) {
            case GUARD: {
                mainModel = guardModel;
                break;
            }
            case COUNCIL: {
                mainModel = councilModel;
            }
        }
        this.field_77045_g = (BipedModel)mainModel;
        ((BipedModel)this.field_77045_g).field_78116_c.field_78806_j = false;
        ((BipedModel)this.field_77045_g).field_178720_f.field_78806_j = (Boolean)RegenConfig.CLIENT.renderTimelordHeadwear.get() == false;
        super.func_225623_a_((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    @Nullable
    public ResourceLocation getTextureLocation(TimelordEntity entity) {
        String gender = entity.male() ? "male" : "female";
        switch (entity.getTimelordType()) {
            case COUNCIL: {
                return new ResourceLocation("regen", "textures/entity/timelords/timelord/timelord_council_" + gender + ".png");
            }
            case GUARD: {
                return new ResourceLocation("regen", "textures/entity/timelords/guards/timelord_guard.png");
            }
        }
        return null;
    }
}

