/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.client.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import me.craig.software.regen.client.rendering.model.ArmModel;
import me.craig.software.regen.client.rendering.model.ContainerModel;
import me.craig.software.regen.client.skin.SkinHandler;
import me.craig.software.regen.common.block.JarBlock;
import me.craig.software.regen.common.item.HandItem;
import me.craig.software.regen.common.tiles.JarTile;
import me.craig.software.regen.util.RegenUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;

public class JarTileRender
extends TileEntityRenderer<JarTile> {
    private static final ResourceLocation TEXTURE_STEVE = new ResourceLocation("textures/entity/steve.png");
    private static final ResourceLocation TEXTURE_ALEX = new ResourceLocation("textures/entity/alex.png");
    public static HashMap<JarTile, ResourceLocation> TEXTURES = new HashMap();
    ArmModel steveArmModel = new ArmModel(false);
    ArmModel armModel = new ArmModel(true);
    EntityModel mainModel = new ArmModel(true);
    ContainerModel containerModel = new ContainerModel();

    public JarTileRender(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(JarTile tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        BlockState blockstate = tileEntityIn.func_195044_w();
        float rotation = 22.5f * (float)((Integer)blockstate.func_177229_b((Property)JarBlock.ROTATION)).intValue();
        if (tileEntityIn.getHand().func_77973_b() instanceof HandItem && !tileEntityIn.isValid(JarTile.Action.CREATE) && Minecraft.func_71382_s()) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 1.2, 0.5);
            matrixStackIn.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
            matrixStackIn.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
            float f2 = -fontrenderer.func_238414_a_((ITextProperties)new TranslationTextComponent(String.valueOf(RegenUtil.round(tileEntityIn.getLindos(), 2)))) / 2;
            fontrenderer.func_243247_a((ITextComponent)new TranslationTextComponent(String.valueOf(RegenUtil.round(tileEntityIn.getLindos(), 2))), f2, 1.0f, -1, false, matrix4f, bufferIn, false, 0, combinedLightIn);
            matrixStackIn.func_227865_b_();
        }
        if (tileEntityIn.isUpdateSkin()) {
            TEXTURES.remove((Object)tileEntityIn);
        }
        if (tileEntityIn.getHand().func_77973_b() instanceof HandItem) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, -0.6, 0.5);
            boolean isAlex = HandItem.isAlex(tileEntityIn.getHand());
            this.mainModel = isAlex ? this.armModel : this.steveArmModel;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
            matrixStackIn.func_227862_a_(0.8f, 0.8f, 0.8f);
            matrixStackIn.func_227861_a_(0.0, (double)0.1f, 0.04);
            this.mainModel.func_225598_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getOrCreateTexture(tileEntityIn))), combinedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227865_b_();
        } else {
            TEXTURES.remove((Object)tileEntityIn);
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStackIn.func_227861_a_(0.5, -1.5, 0.5);
        matrixStackIn.func_227861_a_(-1.0, 0.0, -1.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        this.containerModel.Lid.field_78795_f = -(tileEntityIn.getOpenAmount() * 1.0471976f);
        this.containerModel.Lid.field_78796_g = 0.0f;
        this.containerModel.Lid.field_78808_h = 0.0f;
        this.containerModel.func_225598_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)ContainerModel.CONTAINER_TEXTURE)), combinedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getOrCreateTexture(JarTile tileEntityHandInJar) {
        if (!tileEntityHandInJar.getHand().func_196082_o().func_74764_b("skin")) {
            boolean isAlex = HandItem.isAlex(tileEntityHandInJar.getHand());
            return isAlex ? TEXTURE_ALEX : TEXTURE_STEVE;
        }
        if (!TEXTURES.containsKey((Object)tileEntityHandInJar)) {
            NativeImage image = SkinHandler.genSkinNative(HandItem.getSkin(tileEntityHandInJar.getHand()));
            ResourceLocation res = Minecraft.func_71410_x().func_110434_K().func_110578_a("hand_", new DynamicTexture(image));
            TEXTURES.put(tileEntityHandInJar, res);
            return res;
        }
        return TEXTURES.get((Object)tileEntityHandInJar);
    }

    private void add(Fluid fluid, IBlockDisplayReader lightReader, BlockPos posIn, IVertexBuilder renderer, MatrixStack stack, float x, float y, float z, float u, float v) {
        int i = fluid.getFluid().getAttributes().getColor(lightReader, posIn);
        float alpha = (float)(i >> 24 & 0xFF) / 255.0f;
        float r = (float)(i >> 16 & 0xFF) / 255.0f;
        float g = (float)(i >> 8 & 0xFF) / 255.0f;
        float b = (float)(i & 0xFF) / 255.0f;
        int j = this.getCombinedAverageLight(lightReader, posIn);
        renderer.func_227888_a_(stack.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(r, g, b, alpha).func_225583_a_(u, v).func_225587_b_(j & 0xFFFF, j >> 16 & 0xFFFF).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }

    private int getCombinedAverageLight(IBlockDisplayReader lightReaderIn, BlockPos posIn) {
        int i = WorldRenderer.func_228421_a_((IBlockDisplayReader)lightReaderIn, (BlockPos)posIn);
        int j = WorldRenderer.func_228421_a_((IBlockDisplayReader)lightReaderIn, (BlockPos)posIn.func_177984_a());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return Math.max(k, l) | Math.max(i1, j1) << 16;
    }
}

