/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen.client.animation;

import java.util.concurrent.atomic.AtomicBoolean;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.state.RegenStates;
import me.craig.software.regen.common.regen.transitions.TransitionType;
import me.craig.software.regen.common.regen.transitions.TransitionTypeRenderers;
import me.craig.software.regen.util.PlayerUtil;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;

public class AnimationHandler {
    public static Item[] LEG_ITEMS = new Item[]{(Item)RItems.F_ROBES_LEGS.get(), (Item)RItems.M_ROBES_LEGS.get(), (Item)RItems.GUARD_LEGS.get(), (Item)RItems.ROBES_FEET.get()};
    public static Item[] BODY_ITEMS = new Item[]{(Item)RItems.F_ROBES_CHEST.get(), (Item)RItems.GUARD_CHEST.get(), (Item)RItems.M_ROBES_CHEST.get()};

    public static void setRotationAnglesCallback(BipedModel<?> bipedModel, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        RegenCap.get(livingEntity).ifPresent(iRegen -> {
            TransitionType type = iRegen.transitionType();
            TransitionTypeRenderers.get(type).animate(bipedModel, livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (iRegen.regenState() != RegenStates.REGENERATING && livingEntity.func_200600_R() == EntityType.field_200729_aH) {
                AnimationHandler.handleArmor(bipedModel, livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
            if (livingEntity.func_200600_R() == EntityType.field_200729_aH && PlayerUtil.isPlayerAboveZeroGrid(livingEntity) && iRegen.regenState() == RegenStates.POST) {
                bipedModel.field_78116_c.field_78795_f = (float)Math.toRadians(20.0);
                bipedModel.field_78116_c.field_78796_g = (float)Math.toRadians(0.0);
                bipedModel.field_78116_c.field_78808_h = (float)Math.toRadians(0.0);
                bipedModel.field_178722_k.field_78808_h = (float)Math.toRadians(-2.0);
                bipedModel.field_178721_j.field_78808_h = (float)Math.toRadians(2.0);
            }
        });
        AnimationHandler.correctPlayerModel(bipedModel);
    }

    public static void handleArmor(BipedModel bipedModel, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (bipedModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)bipedModel;
            playerModel.field_178730_v.field_78806_j = AnimationHandler.hideModelPartIf(livingEntity, BODY_ITEMS, PlayerModelPart.JACKET, EquipmentSlotType.CHEST);
            playerModel.field_178732_b.field_78806_j = livingEntity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() != RItems.GUARD_CHEST.get();
            playerModel.field_178734_a.field_78806_j = playerModel.field_178732_b.field_78806_j;
            playerModel.field_178733_c.field_78806_j = AnimationHandler.hideModelPartIf(livingEntity, LEG_ITEMS, PlayerModelPart.LEFT_PANTS_LEG, EquipmentSlotType.LEGS);
            playerModel.field_178731_d.field_78806_j = AnimationHandler.hideModelPartIf(livingEntity, LEG_ITEMS, PlayerModelPart.RIGHT_PANTS_LEG, EquipmentSlotType.LEGS);
            playerModel.field_178734_a.field_78806_j = playerModel.field_178724_i.field_78806_j = AnimationHandler.showArms(livingEntity);
        }
    }

    public static boolean showArms(LivingEntity livingEntity) {
        AtomicBoolean show = new AtomicBoolean(true);
        RegenCap.get(livingEntity).ifPresent(iRegen -> show.set(iRegen.handState() == IRegen.Hand.LEFT_GONE));
        return !show.get();
    }

    public static void correctPlayerModel(BipedModel bipedModel) {
        if (bipedModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)bipedModel;
            playerModel.field_178720_f.func_217177_a(playerModel.field_78116_c);
            playerModel.field_178734_a.func_217177_a(playerModel.field_178724_i);
            playerModel.field_178732_b.func_217177_a(playerModel.field_178723_h);
            playerModel.field_178733_c.func_217177_a(playerModel.field_178722_k);
            playerModel.field_178731_d.func_217177_a(playerModel.field_178721_j);
        }
    }

    public static boolean hideModelPartIf(LivingEntity livingEntity, Item[] items, PlayerModelPart part, EquipmentSlotType slot) {
        for (Item item : items) {
            if (livingEntity.func_184582_a(slot).func_77973_b() != item) continue;
            return false;
        }
        if (livingEntity instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)livingEntity;
            return player.func_175148_a(part);
        }
        return true;
    }

    public static interface Animation {
        public void animate(BipedModel<?> var1, LivingEntity var2, float var3, float var4, float var5, float var6, float var7);
    }
}

