/*
 * Decompiled with CFR 0.152.
 */
package me.craig.software.regen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import me.craig.software.regen.common.advancement.TriggerManager;
import me.craig.software.regen.common.entities.TimelordEntity;
import me.craig.software.regen.common.objects.RBlocks;
import me.craig.software.regen.common.objects.REntities;
import me.craig.software.regen.common.objects.RGlobalLoot;
import me.craig.software.regen.common.objects.RItems;
import me.craig.software.regen.common.objects.RParticles;
import me.craig.software.regen.common.objects.RSounds;
import me.craig.software.regen.common.objects.RTiles;
import me.craig.software.regen.common.regen.IRegen;
import me.craig.software.regen.common.regen.RegenCap;
import me.craig.software.regen.common.regen.RegenStorage;
import me.craig.software.regen.common.regen.acting.ActingForwarder;
import me.craig.software.regen.common.regen.transitions.TransitionTypes;
import me.craig.software.regen.common.traits.RegenTraitRegistry;
import me.craig.software.regen.common.world.biome.surface.RSurfaceBuilder;
import me.craig.software.regen.common.world.gen.RStructures;
import me.craig.software.regen.compat.TardisMod;
import me.craig.software.regen.config.RegenConfig;
import me.craig.software.regen.data.AdvancementGen;
import me.craig.software.regen.data.EnglishLang;
import me.craig.software.regen.data.LootGen;
import me.craig.software.regen.data.RBlockLootTableGen;
import me.craig.software.regen.data.RBlockTags;
import me.craig.software.regen.data.RItemTags;
import me.craig.software.regen.data.RRecipeGen;
import me.craig.software.regen.network.NetworkDispatcher;
import me.craig.software.regen.util.ClientUtil;
import me.craig.software.regen.util.DownloadSkinsThread;
import me.craig.software.regen.util.PlayerUtil;
import net.minecraft.data.BiomeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="regen")
public class Regeneration {
    public static final Logger LOG = LogManager.getLogger((String)"Regeneration");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public Regeneration() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff));
        modBus.addListener(this::doCommonStuff);
        modBus.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        RBlocks.BLOCKS.register(modBus);
        RSounds.SOUNDS.register(modBus);
        RItems.ITEMS.register(modBus);
        REntities.ENTITIES.register(modBus);
        RTiles.TILES.register(modBus);
        RStructures.Structures.STRUCTURES.register(modBus);
        RStructures.FEATURES.register(modBus);
        RParticles.TYPES.register(modBus);
        RGlobalLoot.GLM.register(modBus);
        RSurfaceBuilder.SurfaceBuilders.SURFACE_BUILDERS.register(modBus);
        RegenTraitRegistry.TRAITS.register(modBus);
        TransitionTypes.TRANSITION_TYPES.register(modBus);
        NetworkDispatcher.init();
        PlayerUtil.setupPotions();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, RegenConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RegenConfig.COMMON_SPEC);
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RSurfaceBuilder.registerConfiguredSurfaceBuilders();
            RStructures.setupStructures();
            RStructures.ConfiguredStructures.registerConfiguredStructures();
            RStructures.registerConfiguredFeatures();
        });
        CapabilityManager.INSTANCE.register(IRegen.class, (Capability.IStorage)new RegenStorage(), RegenCap::new);
        ActingForwarder.init();
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)REntities.TIMELORD.get()), (AttributeModifierMap)TimelordEntity.createAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)REntities.WATCHER.get()), (AttributeModifierMap)TimelordEntity.createAttributes().func_233813_a_());
        DownloadSkinsThread.setup();
        TriggerManager.init();
        if (ModList.get().isLoaded("tardis")) {
            TardisMod.tardis();
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ClientUtil::doClientStuff);
    }

    @SubscribeEvent
    public void onGatherData(GatherDataEvent e) {
        DataGenerator generator = e.getGenerator();
        boolean reports = false;
        ExistingFileHelper existingFileHelper = e.getExistingFileHelper();
        generator.func_200390_a((IDataProvider)new EnglishLang(generator));
        generator.func_200390_a((IDataProvider)new RBlockLootTableGen(generator));
        generator.func_200390_a((IDataProvider)new LootGen(generator));
        RBlockTags blockTags = new RBlockTags(generator, existingFileHelper);
        generator.func_200390_a((IDataProvider)blockTags);
        generator.func_200390_a((IDataProvider)new RItemTags(generator, blockTags, existingFileHelper));
        generator.func_200390_a((IDataProvider)new RRecipeGen(generator));
        generator.func_200390_a((IDataProvider)new AdvancementGen(generator));
        if (reports) {
            generator.func_200390_a((IDataProvider)new BiomeProvider(generator));
        }
    }
}

