/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class FluidObject<F extends ForgeFlowingFluid>
implements Supplier<F>,
IItemProvider {
    protected ResourceLocation id;
    private Tags.IOptionalNamedTag<Fluid> localTag;
    private Tags.IOptionalNamedTag<Fluid> forgeTag;
    private final Supplier<? extends F> still;
    private final Supplier<? extends F> flowing;
    @Nullable
    private final Supplier<? extends FlowingFluidBlock> block;

    public FluidObject(ResourceLocation id, String tagName, Supplier<? extends F> still, Supplier<? extends F> flowing, @Nullable Supplier<? extends FlowingFluidBlock> block) {
        this.id = id;
        this.localTag = FluidTags.createOptional((ResourceLocation)id);
        this.forgeTag = FluidTags.createOptional((ResourceLocation)new ResourceLocation("forge", tagName));
        this.still = still;
        this.flowing = flowing;
        this.block = block;
    }

    @Deprecated
    public FluidObject(Supplier<? extends F> still, Supplier<? extends F> flowing, @Nullable Supplier<? extends FlowingFluidBlock> block) {
        this.still = still;
        this.flowing = flowing;
        this.block = block;
    }

    public ResourceLocation getId() {
        if (this.id == null) {
            this.id = Objects.requireNonNull(this.getStill().getRegistryName(), "Fluid has null ID");
        }
        return this.id;
    }

    public F getStill() {
        return (F)((ForgeFlowingFluid)Objects.requireNonNull(this.still.get(), "Fluid object missing still fluid"));
    }

    @Override
    public F get() {
        return this.getStill();
    }

    public F getFlowing() {
        return (F)((ForgeFlowingFluid)Objects.requireNonNull(this.flowing.get(), "Fluid object missing flowing fluid"));
    }

    @Nullable
    public FlowingFluidBlock getBlock() {
        if (this.block == null) {
            return null;
        }
        return this.block.get();
    }

    public Item func_199767_j() {
        return ((ForgeFlowingFluid)this.still.get()).func_204524_b();
    }

    public Tags.IOptionalNamedTag<Fluid> getLocalTag() {
        if (this.localTag == null) {
            this.localTag = FluidTags.createOptional((ResourceLocation)this.getId());
        }
        return this.localTag;
    }

    public Tags.IOptionalNamedTag<Fluid> getForgeTag() {
        if (this.forgeTag == null) {
            this.forgeTag = FluidTags.createOptional((ResourceLocation)new ResourceLocation("forge", this.getId().func_110623_a()));
        }
        return this.forgeTag;
    }
}

