/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.ItemOutput;

public class ItemNameOutput
extends ItemOutput {
    private final ResourceLocation name;
    private final int count;
    @Nullable
    private final CompoundNBT nbt;

    public static ItemNameOutput fromName(ResourceLocation name, int count) {
        return ItemNameOutput.fromName(name, count, null);
    }

    public static ItemNameOutput fromName(ResourceLocation name) {
        return ItemNameOutput.fromName(name, 1);
    }

    @Override
    public ItemStack get() {
        throw new UnsupportedOperationException("Cannot get the item stack from a item name output");
    }

    @Override
    public JsonElement serialize() {
        String itemName = this.name.toString();
        if (this.nbt == null && this.count <= 1) {
            return new JsonPrimitive(itemName);
        }
        JsonObject jsonResult = new JsonObject();
        jsonResult.addProperty("item", itemName);
        if (this.count > 1) {
            jsonResult.addProperty("count", (Number)this.count);
        }
        if (this.nbt != null) {
            jsonResult.addProperty("nbt", this.nbt.toString());
        }
        return jsonResult;
    }

    private ItemNameOutput(ResourceLocation name, int count, @Nullable CompoundNBT nbt) {
        this.name = name;
        this.count = count;
        this.nbt = nbt;
    }

    public static ItemNameOutput fromName(ResourceLocation name, int count, @Nullable CompoundNBT nbt) {
        return new ItemNameOutput(name, count, nbt);
    }
}

