/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.util.JsonHelper;

public abstract class EntityIngredient
implements Predicate<EntityType<?>> {
    public static final EntityIngredient EMPTY = new SetMatch(Collections.emptySet());

    public abstract Collection<EntityType<?>> getTypes();

    public abstract JsonElement serialize();

    public void write(PacketBuffer buffer) {
        Collection<EntityType<?>> collection = this.getTypes();
        buffer.func_150787_b(collection.size());
        for (EntityType<?> type : collection) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ENTITIES, type);
        }
    }

    public static EntityIngredient of(EntityType<?> type) {
        return new Single(type);
    }

    public static EntityIngredient of(Set<EntityType<?>> set) {
        return new SetMatch(set);
    }

    public static EntityIngredient of(EntityType<?> ... types) {
        return EntityIngredient.of(ImmutableSet.copyOf((Object[])types));
    }

    public static EntityIngredient of(ITag<EntityType<?>> tag) {
        return new TagMatch(tag);
    }

    public static EntityIngredient of(EntityIngredient ... ingredients) {
        return new Compound(Arrays.asList(ingredients));
    }

    public static EntityIngredient read(PacketBuffer buffer) {
        int count = buffer.func_150792_a();
        if (count == 1) {
            return new Single((EntityType)buffer.readRegistryIdUnsafe(ForgeRegistries.ENTITIES));
        }
        ArrayList<IForgeRegistryEntry> list = new ArrayList<IForgeRegistryEntry>(count);
        for (int i = 0; i < count; ++i) {
            list.add(buffer.readRegistryIdUnsafe(ForgeRegistries.ENTITIES));
        }
        return new SetMatch((Set<EntityType<?>>)ImmutableSet.copyOf(list));
    }

    private static EntityType<?> findEntityType(ResourceLocation name) {
        EntityType type;
        if (ForgeRegistries.ENTITIES.containsKey(name) && (type = (EntityType)ForgeRegistries.ENTITIES.getValue(name)) != null) {
            return type;
        }
        throw new JsonSyntaxException("Invalid entity type " + name);
    }

    public static EntityIngredient deserialize(JsonElement root) {
        if (root.isJsonArray()) {
            JsonArray array = root.getAsJsonArray();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonElement element2 : array) {
                builder.add((Object)EntityIngredient.deserialize(element2));
            }
            return new Compound((List<EntityIngredient>)builder.build());
        }
        if (!root.isJsonObject()) {
            throw new JsonSyntaxException("Entity ingredient must be either an object or an array");
        }
        JsonObject json = root.getAsJsonObject();
        if (json.has("type")) {
            ResourceLocation name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"type"));
            return new Single(EntityIngredient.findEntityType(name));
        }
        if (json.has("tag")) {
            ResourceLocation name = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
            ITag tag = TagCollectionManager.func_242178_a().func_241838_d().func_199910_a(name);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown entity type tag " + name);
            }
            return new TagMatch(tag);
        }
        if (json.has("types")) {
            List<EntityType> types = JsonHelper.parseList(json, "types", (element, key) -> EntityIngredient.findEntityType(new ResourceLocation(JSONUtils.func_151206_a((JsonElement)element, (String)key))));
            return new SetMatch((Set<EntityType<?>>)ImmutableSet.copyOf(types));
        }
        throw new JsonSyntaxException("Invalid entity type ingredient, must have 'type', 'types', or 'tag'");
    }

    private static class Compound
    extends EntityIngredient {
        private final List<EntityIngredient> ingredients;
        private List<EntityType<?>> allTypes;

        @Override
        public boolean test(EntityType<?> type) {
            for (EntityIngredient ingredient : this.ingredients) {
                if (!ingredient.test(type)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<EntityType<?>> getTypes() {
            if (this.allTypes == null) {
                this.allTypes = this.ingredients.stream().flatMap(ingredient -> ingredient.getTypes().stream()).distinct().collect(Collectors.toList());
            }
            return this.allTypes;
        }

        @Override
        public JsonElement serialize() {
            JsonArray array = new JsonArray();
            for (EntityIngredient ingredient : this.ingredients) {
                array.add(ingredient.serialize());
            }
            return array;
        }

        public Compound(List<EntityIngredient> ingredients) {
            this.ingredients = ingredients;
        }
    }

    private static class TagMatch
    extends EntityIngredient {
        private final ITag<EntityType<?>> tag;

        @Override
        public boolean test(EntityType<?> type) {
            return this.tag.func_230235_a_(type);
        }

        public List<EntityType<?>> getTypes() {
            return this.tag.func_230236_b_();
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("tag", TagCollectionManager.func_242178_a().func_241838_d().func_232975_b_(this.tag).toString());
            return object;
        }

        public TagMatch(ITag<EntityType<?>> tag) {
            this.tag = tag;
        }
    }

    private static class SetMatch
    extends EntityIngredient {
        private final Set<EntityType<?>> types;

        @Override
        public boolean test(EntityType<?> type) {
            return this.types.contains(type);
        }

        public Set<EntityType<?>> getTypes() {
            return this.types;
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            JsonArray array = new JsonArray();
            for (EntityType type : this.getTypes()) {
                array.add(Objects.requireNonNull(type.getRegistryName()).toString());
            }
            object.add("types", (JsonElement)array);
            return object;
        }

        public SetMatch(Set<EntityType<?>> types) {
            this.types = types;
        }
    }

    private static class Single
    extends EntityIngredient {
        private final EntityType<?> type;

        @Override
        public boolean test(EntityType<?> type) {
            return type == this.type;
        }

        public List<EntityType<?>> getTypes() {
            return Collections.singletonList(this.type);
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("type", Objects.requireNonNull(this.type.getRegistryName()).toString());
            return object;
        }

        public Single(EntityType<?> type) {
            this.type = type;
        }
    }
}

