/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.loot.AddEntryLootModifier;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.loot.builder.AbstractLootModifierBuilder;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;

public class ReplaceItemLootModifier
extends LootModifier {
    private final Ingredient original;
    private final ItemOutput replacement;
    private final ILootFunction[] functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> combinedFunctions;

    protected ReplaceItemLootModifier(ILootCondition[] conditionsIn, Ingredient original, ItemOutput replacement, ILootFunction[] functions) {
        super(conditionsIn);
        this.original = original;
        this.replacement = replacement;
        this.functions = functions;
        this.combinedFunctions = LootFunctionManager.func_216241_a((BiFunction[])functions);
    }

    @Deprecated
    protected ReplaceItemLootModifier(ILootCondition[] conditionsIn, Item original, Item replacement) {
        this(conditionsIn, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{original}), ItemOutput.fromItem((IItemProvider)replacement), new ILootFunction[0]);
    }

    public static Builder builder(Ingredient original, ItemOutput replacement) {
        return new Builder(original, replacement);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        return generatedLoot.stream().map(stack -> {
            if (this.original.test(stack)) {
                ItemStack replacement = this.replacement.get();
                return this.combinedFunctions.apply(ItemHandlerHelper.copyStackWithSize((ItemStack)replacement, (int)(replacement.func_190916_E() * stack.func_190916_E())), context);
            }
            return stack;
        }).collect(Collectors.toList());
    }

    public static class Builder
    extends AbstractLootModifierBuilder<Builder> {
        private final Ingredient input;
        private final ItemOutput replacement;
        private final List<ILootFunction> functions = new ArrayList<ILootFunction>();

        public Builder addFunction(ILootFunction function) {
            this.functions.add(function);
            return this;
        }

        @Override
        public void build(String name, GlobalLootModifierProvider provider) {
            provider.add(name, (GlobalLootModifierSerializer)MantleLoot.REPLACE_ITEM, (IGlobalLootModifier)new ReplaceItemLootModifier(this.getConditions(), this.input, this.replacement, this.functions.toArray(new ILootFunction[0])));
        }

        private Builder(Ingredient input, ItemOutput replacement) {
            this.input = input;
            this.replacement = replacement;
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ReplaceItemLootModifier> {
        public ReplaceItemLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            JsonElement element = JsonHelper.getElement(object, "original");
            Ingredient original = element.isJsonPrimitive() ? Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)RecipeHelper.deserializeItem(element.getAsString(), "original", Item.class)}) : Ingredient.func_199802_a((JsonElement)element);
            ItemOutput replacement = ItemOutput.fromJson(JsonHelper.getElement(object, "replacement"));
            ILootFunction[] functions = object.has("functions") ? (ILootFunction[])AddEntryLootModifier.GSON.fromJson((JsonElement)JSONUtils.func_151214_t((JsonObject)object, (String)"functions"), ILootFunction[].class) : new ILootFunction[]{};
            return new ReplaceItemLootModifier(conditions, original, replacement, functions);
        }

        public JsonObject write(ReplaceItemLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.add("original", instance.original.func_200304_c());
            object.add("replacement", instance.replacement.serialize());
            if (instance.functions.length > 0) {
                object.add("functions", AddEntryLootModifier.GSON.toJsonTree((Object)instance.functions, ILootFunction[].class));
            }
            return object;
        }
    }
}

