/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.structure;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.template.Template;

public class StructureInfo
implements Predicate<BlockPos> {
    public Map<BlockPos, Template.BlockInfo> data = new HashMap<BlockPos, Template.BlockInfo>();
    public final int structureHeight;
    public final int structureLength;
    public final int structureWidth;
    public final int maxBlockIndex;
    public int showLayer = -1;
    public int blockIndex;

    public StructureInfo(List<Template.BlockInfo> structure) {
        int structureHeight = 0;
        int structureWidth = 0;
        int structureLength = 0;
        for (Template.BlockInfo block : structure) {
            structureHeight = Math.max(structureHeight, block.field_186242_a.func_177956_o() + 1);
            structureWidth = Math.max(structureWidth, block.field_186242_a.func_177952_p() + 1);
            structureLength = Math.max(structureLength, block.field_186242_a.func_177958_n() + 1);
            this.data.put(block.field_186242_a, block);
        }
        this.maxBlockIndex = this.blockIndex = structureHeight * structureLength * structureWidth;
        this.structureHeight = structureHeight;
        this.structureLength = structureLength;
        this.structureWidth = structureWidth;
    }

    public void setShowLayer(int layer) {
        this.showLayer = layer;
        if (layer < 0) {
            this.reset();
        } else {
            this.blockIndex = (layer + 1) * (this.structureLength * this.structureWidth) - 1;
        }
    }

    public void reset() {
        this.blockIndex = this.maxBlockIndex;
    }

    public void step() {
        int start = this.blockIndex;
        do {
            if (++this.blockIndex < this.maxBlockIndex) continue;
            this.blockIndex = 0;
        } while (this.isEmpty(this.blockIndex) && this.blockIndex != start);
    }

    private boolean isEmpty(int index) {
        int r = index % (this.structureLength * this.structureWidth);
        int x = r / this.structureWidth;
        int y = index / (this.structureLength * this.structureWidth);
        int z = r % this.structureWidth;
        return !this.data.containsKey(new BlockPos(x, y, z));
    }

    public int getLimiter() {
        return this.blockIndex;
    }

    @Override
    public boolean test(BlockPos blockPos) {
        int index = blockPos.func_177952_p() + this.structureWidth * (blockPos.func_177958_n() + this.structureLength * blockPos.func_177956_o());
        return index <= this.getLimiter();
    }
}

