/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentBlank;
import slimeknights.mantle.client.book.data.content.ContentPadding;
import slimeknights.mantle.client.book.data.content.ContentSectionList;
import slimeknights.mantle.client.book.data.content.ContentTableOfContents;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;

public abstract class BookTransformer {
    public static BookTransformer indexTranformer() {
        return IndexTranformer.INSTANCE;
    }

    public static BookTransformer contentTableTransformer() {
        return ContentTableTransformer.INSTANCE;
    }

    public static BookTransformer contentTableTransformerForSection(String sectionName) {
        return new ContentTableTransformer(sectionName);
    }

    public static BookTransformer paddingTransformer() {
        return ContentPadding.PaddingBookTransformer.INSTANCE;
    }

    public abstract void transform(BookData var1);

    protected static class ContentTableTransformer
    extends BookTransformer {
        public static final ContentTableTransformer INSTANCE = new ContentTableTransformer();
        private final String sectionToTransform;

        public ContentTableTransformer(String sectionToTransform) {
            this.sectionToTransform = sectionToTransform;
        }

        public ContentTableTransformer() {
            this.sectionToTransform = null;
        }

        @Override
        public void transform(BookData book) {
            int ENTRIES_PER_PAGE = 24;
            for (SectionData section : book.sections) {
                int i;
                int genPages;
                if (section.name.equals("index") || this.sectionToTransform != null && !section.name.equals(this.sectionToTransform) || (genPages = (int)Math.ceil((float)section.getPageCount() * 1.0f / 24.0f)) == 0) continue;
                PageData[] pages = new PageData[genPages];
                for (i = 0; i < pages.length; ++i) {
                    pages[i] = new PageData(true);
                    pages[i].name = "tableofcontents" + i;
                    TextData[] text = new TextData[i > pages.length - 1 ? 24 : section.getPageCount() - (genPages - 1) * 24];
                    for (int j = 0; j < text.length; ++j) {
                        text[j] = new TextData(i * 24 + j + 1 + ". " + section.pages.get(i * 24 + j).getTitle());
                        text[j].action = "go-to-page-rtn:" + section.name + "." + section.pages.get((int)(i * 24 + j)).name;
                    }
                    pages[i].content = new ContentTableOfContents(i == 0 ? section.getTitle() : "", text);
                }
                for (i = pages.length - 1; i >= 0; --i) {
                    section.pages.add(0, pages[i]);
                }
            }
        }
    }

    protected static class IndexTranformer
    extends BookTransformer {
        public static final IndexTranformer INSTANCE = new IndexTranformer();

        protected IndexTranformer() {
        }

        private static int ceilingDivide(int value, int divisor) {
            int result = value / divisor;
            if (value % divisor != 0) {
                ++result;
            }
            return result;
        }

        @Override
        public void transform(BookData book) {
            final int sectionsPerPage = book.appearance.drawFourColumnIndex ? 12 : 9;
            SectionData index = new SectionData(true){

                @Override
                public void update(@Nullable BookScreen.AdvancementCache advancementCache) {
                    this.pages.clear();
                    List<SectionData> visibleSections = this.parent.getVisibleSections(advancementCache);
                    if (visibleSections.isEmpty()) {
                        return;
                    }
                    visibleSections.remove(0);
                    PageData[] pages = new PageData[IndexTranformer.ceilingDivide(visibleSections.size(), sectionsPerPage)];
                    for (int i = 0; i < pages.length; ++i) {
                        int pageStart;
                        pages[i] = new PageData(true);
                        pages[i].name = "page" + (i + 1);
                        ContentSectionList content = new ContentSectionList();
                        pages[i].content = content;
                        for (int j = pageStart = i * sectionsPerPage; j - pageStart < 16 && j < visibleSections.size(); ++j) {
                            content.addSection(visibleSections.get(j));
                        }
                    }
                    this.pages.addAll(Arrays.asList(pages));
                }
            };
            List<SectionData> visibleSections = book.getVisibleSections(null);
            if (!visibleSections.isEmpty()) {
                PageData[] pages = new PageData[IndexTranformer.ceilingDivide(visibleSections.size() - 1, sectionsPerPage)];
                for (int i = 0; i < pages.length; ++i) {
                    pages[i] = new PageData(true);
                    pages[i].name = "page" + (i + 1);
                    pages[i].content = new ContentBlank();
                }
                index.pages.addAll(Arrays.asList(pages));
            }
            index.name = "index";
            book.sections.add(0, index);
        }
    }
}

