/*
 * Decompiled with CFR 0.152.
 */
package com.vandendaelen.handles.tardis.upgrades;

import com.vandendaelen.handles.Handles;
import com.vandendaelen.handles.blocks.tiles.TardisInterfaceTile;
import com.vandendaelen.handles.misc.TardisInterfacePeripheral;
import dan200.computercraft.shared.Capabilities;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.upgrades.Upgrade;
import net.tardis.mod.upgrades.UpgradeEntry;

public class AprioritronUpgrade
extends Upgrade {
    Set<TardisInterfaceTile> activeInterfaces = new LinkedHashSet<TardisInterfaceTile>();

    protected AprioritronUpgrade(UpgradeEntry entry, ConsoleTile tile, Class<? extends Subsystem> clazz) {
        super(entry, tile, clazz);
    }

    public void onFlightSecond() {
    }

    public void onLand() {
        for (TardisInterfaceTile tile : this.activeInterfaces) {
            tile.getCapability(Capabilities.CAPABILITY_PERIPHERAL, null).ifPresent(iPeripheral -> {
                TardisInterfacePeripheral tardisInterface = (TardisInterfacePeripheral)iPeripheral;
                BlockPos blockPos = this.getConsole().getCurrentLocation();
                tardisInterface.queueEvent("onTardisLand", blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            });
        }
    }

    public void onTakeoff() {
        for (TardisInterfaceTile tile : this.activeInterfaces) {
            tile.getCapability(Capabilities.CAPABILITY_PERIPHERAL, null).ifPresent(iPeripheral -> {
                TardisInterfacePeripheral tardisInterface = (TardisInterfacePeripheral)iPeripheral;
                BlockPos blockPos = this.getConsole().getDestinationPosition();
                tardisInterface.queueEvent("onTardisTakeoff", blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            });
        }
    }

    public void onBreak() {
        for (TardisInterfaceTile tile : this.activeInterfaces) {
            tile.getCapability(Capabilities.CAPABILITY_PERIPHERAL, null).ifPresent(iPeripheral -> {
                TardisInterfacePeripheral tardisInterface = (TardisInterfacePeripheral)iPeripheral;
                tardisInterface.queueEvent("onTardisAprioritronBreak", new Object[0]);
            });
        }
    }

    public void attachInterface(TardisInterfaceTile interfaceTile) {
        this.activeInterfaces.add(interfaceTile);
        Handles.LOGGER.info("Attaching interface to upgrade.");
    }

    public void detachInterface(TardisInterfaceTile interfaceTile) {
        this.activeInterfaces.remove((Object)interfaceTile);
        Handles.LOGGER.info("Detaching interface from upgrade.");
    }
}

